/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.utils;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ImageUtils {
    public static BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, 6);
        Graphics2D g2 = resizedImage.createGraphics();
        double width_ratio = (float)width / (float)originalImage.getWidth();
        double height_ratio = (float)height / (float)originalImage.getHeight();
        double ratio = Math.min(width_ratio, height_ratio);
        double newWidth = ratio * (double)originalImage.getWidth();
        double newHeight = ratio * (double)originalImage.getHeight();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int imageWidth = (int)newWidth;
        int imageHeight = (int)newHeight;
        int startX = (width - imageWidth) / 2;
        int startY = (height - imageHeight) / 2;
        g2.drawImage(originalImage, startX, startY, imageWidth, imageHeight, null);
        g2.dispose();
        g2.setComposite(AlphaComposite.Src);
        return resizedImage;
    }
}

