/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class NumberUtils {
    public static final Locale LOCALE_RO = new Locale("ro", "RO");
    private static final String BASE_FORMATER_PATTERN = "##,##0";
    private static DecimalFormatSymbols decimalFormatSymbols = null;
    private static DecimalFormat decimalFormater = null;
    private static DecimalFormat integerFormater = null;
    private static int formaterScale = 0;

    private static void initializeFormatSymbols() {
        decimalFormatSymbols = new DecimalFormatSymbols(LOCALE_RO);
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setMinusSign('-');
    }

    private static void initializeDecimalFormat(int scale) {
        if (decimalFormatSymbols == null) {
            NumberUtils.initializeFormatSymbols();
        }
        if (formaterScale != scale) {
            String decimals = "";
            if (scale > 0) {
                decimals = ".";
            }
            for (int i = 0; i < scale; ++i) {
                decimals = decimals + "0";
            }
            decimalFormater = new DecimalFormat(BASE_FORMATER_PATTERN + decimals, decimalFormatSymbols);
        }
    }

    public static NumberFormat getDecimalFormatter(int scale) {
        if (scale != formaterScale) {
            NumberUtils.initializeDecimalFormat(scale);
        }
        return decimalFormater;
    }

    public static String formatBigDecimal(BigDecimal bigDecimal, int scale) {
        if (scale != formaterScale) {
            NumberUtils.initializeDecimalFormat(scale);
        }
        return decimalFormater.format(bigDecimal.doubleValue());
    }

    public static String formatDouble(Double localDouble, int scale) {
        if (scale != formaterScale) {
            NumberUtils.initializeDecimalFormat(scale);
        }
        return decimalFormater.format(localDouble);
    }

    public static String formatInteger(Integer integer) {
        return integerFormater.format(integer);
    }

    public static boolean isValidNumber(String text) {
        ParsePosition p = new ParsePosition(0);
        try {
            NumberUtils.getDecimalFormatter(formaterScale).parse(text, p);
            if (text.length() != p.getIndex() || p.getErrorIndex() != -1) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static boolean isValidInteger(String text) {
        try {
            if (NumberUtils.isValidNumber(text)) {
                Integer.parseInt(text);
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int[] toPrimitive(Integer[] irri) {
        int[] array = new int[irri.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = irri[i];
        }
        return array;
    }

    public static BigDecimal toBigDecimal(String text) {
        if (NumberUtils.isValidNumber(text)) {
            ParsePosition p = new ParsePosition(0);
            Number number = NumberUtils.getDecimalFormatter(formaterScale).parse(text, p);
            return new BigDecimal(number.toString());
        }
        return null;
    }

    public static Double toDouble(String text) {
        if (NumberUtils.isValidNumber(text)) {
            ParsePosition p = new ParsePosition(0);
            Number number = NumberUtils.getDecimalFormatter(formaterScale).parse(text, p);
            return new Double(number.doubleValue());
        }
        return null;
    }

    public static Integer toInteger(String text) {
        if (NumberUtils.isValidInteger(text)) {
            ParsePosition p = new ParsePosition(0);
            Number number = NumberUtils.getDecimalFormatter(formaterScale).parse(text, p);
            return new Integer(number.intValue());
        }
        return null;
    }

    public static void main(String[] args) {
        BigDecimal bigDecimal = NumberUtils.toBigDecimal("100,0,000.20");
        System.out.println(bigDecimal);
    }

    static {
        decimalFormater = new DecimalFormat(BASE_FORMATER_PATTERN);
        integerFormater = new DecimalFormat(BASE_FORMATER_PATTERN);
    }
}

