/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.externalcalls.actions;

import java.io.File;
import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.components.swingworkers.progressworker.ProgressInfoManager;
import ro.genomeartist.gui.controller.externalcalls.ExternalLink;
import ro.genomeartist.gui.controller.settings.SearchFile;
import ro.genomeartist.gui.controller.settings.SearchFileSequence;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSearchFileCallable
extends AbstractProgressCallable<SearchFile> {
    private SearchFileSequence searchFileSequence;

    public CreateSearchFileCallable(SearchFileSequence searchFileSequence) {
        this.searchFileSequence = searchFileSequence;
    }

    public SearchFile call() throws Exception {
        String baseName = this.searchFileSequence.name;
        SearchFile searchFile = new SearchFile();
        searchFile.fileTitle = this.searchFileSequence.name;
        searchFile.isTransposon = this.searchFileSequence.isTransposon;
        this.setProgressRange(0, 5);
        this.setProgressInfo("Creating " + baseName);
        String folderRaw = ReadOnlyConfiguration.getString("FOLDER_RAW");
        String numeRawNew = baseName + ".raw";
        String pathRaw = folderRaw + numeRawNew;
        File newRaw = new File(pathRaw);
        ExternalLink.writeStringToFile(newRaw, this.searchFileSequence.sequence);
        searchFile.rawLocation = newRaw;
        this.setProgressValue(100);
        this.setProgressRange(5, 95);
        AbstractProgressCallable<Boolean> runDataHashing = ExternalLink.getDataHashingCallable(newRaw);
        runDataHashing.setProgressInfoManager((ProgressInfoManager)this);
        runDataHashing.call();
        this.setProgressRange(95, 100);
        String folderGene = ReadOnlyConfiguration.getString("FOLDER_GENE");
        String numeGeneNew = baseName + ".gene";
        String pathGene = folderGene + numeGeneNew;
        File newGene = new File(pathGene);
        ExternalLink.createEmptyFile(newGene);
        searchFile.geneNumber = 0;
        searchFile.geneLocation = newGene;
        this.setProgressValue(100);
        return searchFile;
    }
}

