/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ro.genomeartist.gui.controller.settings.SearchFile;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.utils.JMyBoolean;
import ro.genomeartist.gui.utils.MyUtils;
import ro.genomeartist.gui.utils.StringUtils;

public class JAddFileDialog
extends JDialog {
    private IGlobalManager globalManager;
    private SearchFile searchFileRaw;
    private JMyBoolean isOk;
    private static final String TITLE_FILE = "File information";
    private static final String TEXT_NAME = "Name*";
    private static final String TEXT_SEQUENCE_LOCATION = "Sequence location (.raw)*";
    private static final String TEXT_GENES_LOCATION = "Genes location (.fasta)";
    private static final String TEXT_HINT = "* required fields";
    private static final int FRAME_WIDTH = 500;
    private static final int FRAME_HEIGHT = 200;
    private static final int TEXTFIELD_LENGTH = 10;
    private static final int LABEL_SIZE = 200;
    private static final int HUGE_SIZE = 3000;
    private static final String BUTTON_SEQ = "...";
    private static final String BUTTON_GENE = "...";
    private static final String BUTTON_OK = "    Ok    ";
    private static final String BUTTON_CANCEL = "  Cancel  ";
    private static final String ACTION_SEQ = "seq_file";
    private static final String ACTION_GENE = "gene_file";
    private static final String ACTION_OK = "ok";
    private static final String ACTION_CANCEL = "apply";
    private JPanel middlePane;
    private JPanel namePanel;
    private JLabel labelTextName;
    private JTextField textfieldName;
    private JPanel sequencePanel;
    private JLabel labelTextSequence;
    private JTextField textfieldSequence;
    private JButton buttonSequenceFile;
    private JPanel genesPanel;
    private JLabel labelTextGenes;
    private JTextField textfieldGenes;
    private JButton buttonGeneFile;
    private JPanel hintPanel;
    private JLabel labelTextHint;
    private JPanel bottomPane;
    private JButton buttonOk;
    private JButton buttonCancel;
    private JFileChooser fc;
    ActionListener buttonListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (JAddFileDialog.ACTION_SEQ.equals(cmd)) {
                int returnVal = JAddFileDialog.this.fc.showOpenDialog(JAddFileDialog.this.globalManager.getTheRootFrame());
                if (returnVal == 0) {
                    ((JAddFileDialog)JAddFileDialog.this).searchFileRaw.rawLocation = JAddFileDialog.this.fc.getSelectedFile();
                    JAddFileDialog.this.updatePanelFromRaw();
                }
            } else if (JAddFileDialog.ACTION_GENE.equals(cmd)) {
                int returnVal = JAddFileDialog.this.fc.showOpenDialog(JAddFileDialog.this.globalManager.getTheRootFrame());
                if (returnVal == 0) {
                    ((JAddFileDialog)JAddFileDialog.this).searchFileRaw.geneLocation = JAddFileDialog.this.fc.getSelectedFile();
                    JAddFileDialog.this.updatePanelFromRaw();
                }
            } else if (JAddFileDialog.ACTION_OK.equals(cmd)) {
                String auxString = JAddFileDialog.this.textfieldName.getText();
                if (auxString.isEmpty()) {
                    auxString = "file";
                }
                ((JAddFileDialog)JAddFileDialog.this).searchFileRaw.fileTitle = StringUtils.sanitizeFilename(auxString);
                JAddFileDialog.this.isOk.setTrue();
                JAddFileDialog.this.dispose();
            } else if (JAddFileDialog.ACTION_CANCEL.equals(cmd)) {
                JAddFileDialog.this.isOk.setFalse();
                JAddFileDialog.this.dispose();
            }
        }
    };

    public JAddFileDialog(IGlobalManager globalManager, String title, boolean modal, JMyBoolean isOk) {
        super(globalManager.getTheRootFrame(), title, modal);
        this.setSize(500, 200);
        this.globalManager = globalManager;
        this.searchFileRaw = new SearchFile();
        this.isOk = isOk;
        this.fc = new JFileChooser();
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        this.middlePane = this.createMiddlePane();
        this.add((Component)this.middlePane, "Center");
        this.bottomPane = new JPanel();
        this.bottomPane.setLayout(new BoxLayout(this.bottomPane, 0));
        this.bottomPane.add(Box.createHorizontalGlue());
        this.buttonOk = new JButton(BUTTON_OK);
        this.buttonOk.setActionCommand(ACTION_OK);
        this.buttonOk.addActionListener(this.buttonListener);
        this.bottomPane.add(this.buttonOk);
        this.buttonCancel = new JButton(BUTTON_CANCEL);
        this.buttonCancel.setActionCommand(ACTION_CANCEL);
        this.buttonCancel.addActionListener(this.buttonListener);
        this.bottomPane.add(this.buttonCancel);
        this.bottomPane.add(Box.createHorizontalGlue());
        this.add((Component)this.bottomPane, "South");
        this.setLocationRelativeTo(globalManager.getTheRootFrame());
    }

    private JPanel createMiddlePane() {
        JPanel localPane = new JPanel();
        localPane.setLayout(new BoxLayout(localPane, 1));
        localPane.setBorder(BorderFactory.createTitledBorder(TITLE_FILE));
        this.labelTextName = new JLabel(TEXT_NAME);
        this.textfieldName = new JTextField(10);
        this.textfieldName.setText("name");
        this.namePanel = this.createAlignedPane(this.labelTextName, this.textfieldName, false);
        localPane.add(this.namePanel);
        this.labelTextSequence = new JLabel(TEXT_SEQUENCE_LOCATION);
        this.textfieldSequence = new JTextField(10);
        this.textfieldSequence.setEditable(false);
        this.sequencePanel = this.createAlignedPane(this.labelTextSequence, this.textfieldSequence, false);
        this.buttonSequenceFile = new JButton();
        this.buttonSequenceFile.setText("...");
        this.buttonSequenceFile.setActionCommand(ACTION_SEQ);
        this.buttonSequenceFile.addActionListener(this.buttonListener);
        this.sequencePanel.add(this.buttonSequenceFile);
        localPane.add(this.sequencePanel);
        this.labelTextGenes = new JLabel(TEXT_GENES_LOCATION);
        this.textfieldGenes = new JTextField(10);
        this.textfieldGenes.setEditable(false);
        this.genesPanel = this.createAlignedPane(this.labelTextGenes, this.textfieldGenes, false);
        this.buttonGeneFile = new JButton();
        this.buttonGeneFile.setText("...");
        this.buttonGeneFile.setActionCommand(ACTION_GENE);
        this.buttonGeneFile.addActionListener(this.buttonListener);
        this.genesPanel.add(this.buttonGeneFile);
        localPane.add(this.genesPanel);
        this.labelTextHint = new JLabel(TEXT_HINT);
        MyUtils.increaseLabelFont(this.labelTextHint, -2);
        this.labelTextHint.setForeground(Color.blue);
        this.hintPanel = this.createAlignedPane(this.labelTextHint, new JLabel(" "), true);
        localPane.add(this.hintPanel);
        localPane.add(Box.createVerticalStrut(3000));
        return localPane;
    }

    private JPanel createAlignedPane(JLabel label1, Component component2, boolean withGap) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        label1.setPreferredSize(new Dimension(200, 0));
        panel.add(label1);
        if (withGap) {
            panel.add(Box.createHorizontalGlue());
        }
        panel.add(component2);
        return panel;
    }

    public SearchFile getFileRaw() {
        return this.searchFileRaw;
    }

    private void updatePanelFromRaw() {
        if (this.searchFileRaw.rawLocation != null) {
            this.textfieldSequence.setText(this.searchFileRaw.rawLocation.getPath());
            this.textfieldSequence.setToolTipText(this.searchFileRaw.rawLocation.getPath());
        }
        if (this.searchFileRaw.geneLocation != null) {
            this.textfieldGenes.setText(this.searchFileRaw.geneLocation.getPath());
            this.textfieldGenes.setToolTipText(this.searchFileRaw.geneLocation.getPath());
        }
        this.repaint();
    }
}

