/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.icons;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import ro.genomeartist.components.singleton.IGlobalClass;
import ro.genomeartist.gui.utils.MyUtils;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;

public class JBrandingImages
implements IGlobalClass {
    public static final String GLOBAL_NAME = "JBrandingImages";
    public static final int TOOLBAR = 1;
    private Image iconToolbar;
    private ImageIcon imageIconToolbar;
    private Icon noIcon = null;

    public JBrandingImages() {
        this.loadIcons();
    }

    public void loadIcons() {
        String iconsFolder = ReadOnlyConfiguration.getString("BRANDING_FOLDER");
        String iconsPath = iconsFolder + ReadOnlyConfiguration.getString("ARTIST_36");
        this.iconToolbar = MyUtils.createImage(iconsPath);
        this.imageIconToolbar = new ImageIcon(this.iconToolbar){

            public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintIcon(c, g, x, y);
            }
        };
    }

    public Icon getIcon(int type) {
        switch (type) {
            case 1: {
                if (this.iconToolbar != null) {
                    return this.imageIconToolbar;
                }
                return this.noIcon;
            }
        }
        return this.noIcon;
    }

    public String getGlobalName() {
        return GLOBAL_NAME;
    }
}

