/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.mainpanels.finalresult;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import ro.genomeartist.coloredtable.cellrenderers.AbstractColoredCellRenderer;
import ro.genomeartist.components.coloredtable.AbstractColoredTableModel;
import ro.genomeartist.components.coloredtable.JColoredTable;
import ro.genomeartist.components.headerrenderer.MultilineHeaderRenderer;
import ro.genomeartist.gui.cellrenderers.JGeneWrapperCellRenderer;
import ro.genomeartist.gui.cellrenderers.JTransposonDefaultCellRenderer;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingItem;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingSet;
import ro.genomeartist.gui.controller.genes.GeneItemWrapper;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.dialogs.JGeneMappingDialog;
import ro.genomeartist.gui.interfaces.IGlobalManager;

public class JIntervalMappingSetPane
extends JPanel {
    private IntervalMappingSet intervalMappingSet;
    private JColoredTable tablePartialResults;
    private MyTableModel tableModel;
    private int scale = 2;
    MultilineHeaderRenderer multirenderer;
    TableRowSorter<TableModel> sorter;
    IGlobalManager globalManager;
    private MouseAdapter clickListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int row = JIntervalMappingSetPane.this.tablePartialResults.rowAtPoint(e.getPoint());
                int col = JIntervalMappingSetPane.this.tablePartialResults.columnAtPoint(e.getPoint());
                Object selectedObject = JIntervalMappingSetPane.this.tablePartialResults.getValueAt(row, col);
                if (selectedObject instanceof GeneItemWrapper) {
                    GeneItemWrapper geneItemWrapper = (GeneItemWrapper)selectedObject;
                    JGeneMappingDialog dialog = new JGeneMappingDialog(JIntervalMappingSetPane.this.globalManager, "Gene map", true, geneItemWrapper);
                    dialog.setVisible(true);
                }
            }
        }
    };

    public JIntervalMappingSetPane(IGlobalManager globalManager, IntervalMappingSet intervalMappingSet) {
        this.setLayout(new BorderLayout());
        this.globalManager = globalManager;
        this.intervalMappingSet = intervalMappingSet;
        this.tableModel = new MyTableModel(intervalMappingSet);
        this.tablePartialResults = new JColoredTable((AbstractColoredTableModel)this.tableModel);
        this.tablePartialResults.setAutoResizeMode(1);
        this.tablePartialResults.setSelectionMode(0);
        this.tablePartialResults.setCellSelectionEnabled(true);
        this.tablePartialResults.getTableHeader().setReorderingAllowed(false);
        this.tablePartialResults.setShowHorizontalLines(true);
        this.tablePartialResults.setShowVerticalLines(true);
        this.tablePartialResults.setRowHeight(new IntervalMappingItem().getRecommendedHeight(this));
        this.tablePartialResults.setDefaultCellRenderer((AbstractColoredCellRenderer)new JTransposonDefaultCellRenderer());
        this.tablePartialResults.setDefaultRenderer(GeneItemWrapper.class, (TableCellRenderer)((Object)new JGeneWrapperCellRenderer()));
        this.tablePartialResults.addMouseListener((MouseListener)this.clickListener);
        this.multirenderer = new MultilineHeaderRenderer();
        this.setPrefferedWidth();
        this.add((Component)new JScrollPane((Component)this.tablePartialResults), "Center");
    }

    private void setPrefferedWidth() {
        TableColumnModel columns = this.tablePartialResults.getColumnModel();
        TableColumn column = columns.getColumn(0);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(10);
        column = columns.getColumn(1);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(100);
        column = columns.getColumn(2);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(100);
        column = columns.getColumn(3);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(150);
        column = columns.getColumn(4);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(400);
    }

    private class MyTableModel
    extends AbstractColoredTableModel {
        private IntervalMappingSet dataProvider;

        public MyTableModel(IntervalMappingSet dataProvider) {
            this.dataProvider = dataProvider;
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return this.dataProvider.size();
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "\\";
                }
                case 1: {
                    return "Location";
                }
                case 2: {
                    return "Position\nin query";
                }
                case 3: {
                    return "Coordinates";
                }
                case 4: {
                    return "Annotations";
                }
            }
            assert (false);
            return null;
        }

        public Object getValueAt(int row, int col) {
            String output = new String();
            IntervalMappingItem intervalMappingItem = (IntervalMappingItem)this.dataProvider.elementAt(row);
            switch (col) {
                case 0: {
                    return new Integer(row + 1);
                }
                case 1: {
                    return intervalMappingItem.getFisierOrigine();
                }
                case 2: {
                    output = intervalMappingItem.getPozitieStartQuery() + " .. " + intervalMappingItem.getPozitieStopQuery();
                    return output;
                }
                case 3: {
                    output = intervalMappingItem.getPozitieStartGenom() + " .. " + intervalMappingItem.getPozitieStopGenom();
                    String auxString = intervalMappingItem.isComplement() ? "(-)" : "(+)";
                    output = output + " " + auxString;
                    return output;
                }
                case 4: {
                    return intervalMappingItem.getGeneItemWrapper();
                }
            }
            assert (false);
            return null;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return GeneItemWrapper.class;
                }
            }
            assert (false);
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object value, int row, int col) {
        }

        public Color getBackground(int row, int col) {
            return DrawingConstants.COLOR_TABLE_BG_YELLOW;
        }

        public Color getForeground(int row, int col) {
            return null;
        }
    }
}

