/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.mainpanels.genes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import ro.genomeartist.coloredtable.cellrenderers.AbstractColoredCellRenderer;
import ro.genomeartist.components.coloredtable.AbstractColoredTableModel;
import ro.genomeartist.components.coloredtable.JColoredTable;
import ro.genomeartist.components.headerrenderer.MultilineHeaderRenderer;
import ro.genomeartist.gui.cellrenderers.JGeneWrapperCellRenderer;
import ro.genomeartist.gui.cellrenderers.JTransposonDefaultCellRenderer;
import ro.genomeartist.gui.controller.genes.GeneItem;
import ro.genomeartist.gui.controller.genes.GeneItemWrapper;
import ro.genomeartist.gui.controller.genes.GeneVector;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.interfaces.IGlobalManager;

public class JGeneVectorPane
extends JPanel {
    private GeneVector geneVector;
    private JColoredTable tableGenes;
    private MyTableModel tableModel;
    private int scale = 2;
    MultilineHeaderRenderer multirenderer;
    TableRowSorter<TableModel> sorter;
    IGlobalManager globalManager;
    JScrollPane scrollPane;

    public JGeneVectorPane(GeneVector geneVector) {
        this.setLayout(new BorderLayout());
        this.geneVector = geneVector;
        this.tableModel = new MyTableModel(geneVector);
        this.tableGenes = new JColoredTable((AbstractColoredTableModel)this.tableModel);
        this.tableGenes.setAutoResizeMode(1);
        this.tableGenes.setSelectionMode(0);
        this.tableGenes.getTableHeader().setReorderingAllowed(false);
        this.tableGenes.setShowHorizontalLines(true);
        this.tableGenes.setShowVerticalLines(true);
        this.tableGenes.setDefaultCellRenderer((AbstractColoredCellRenderer)new JTransposonDefaultCellRenderer());
        this.tableGenes.setDefaultRenderer(GeneItemWrapper.class, (TableCellRenderer)((Object)new JGeneWrapperCellRenderer()));
        this.sorter = new TableRowSorter<MyTableModel>(this.tableModel);
        this.tableGenes.setRowSorter(this.sorter);
        this.sorter.toggleSortOrder(0);
        this.multirenderer = new MultilineHeaderRenderer();
        this.setPrefferedWidth();
        this.scrollPane = new JScrollPane((Component)this.tableGenes);
        this.add((Component)this.scrollPane, "Center");
    }

    private void setPrefferedWidth() {
        TableColumnModel columns = this.tableGenes.getColumnModel();
        TableColumn column = columns.getColumn(0);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(50);
        column = columns.getColumn(1);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(50);
        column = columns.getColumn(2);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(70);
        column = columns.getColumn(3);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(130);
        column = columns.getColumn(4);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(40);
        column = columns.getColumn(5);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(100);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public int getSuggestedHeight() {
        int cellSize = 0;
        cellSize += this.tableGenes.getRowHeight();
        cellSize += this.tableGenes.getIntercellSpacing().width;
        int headerSize = 3 * (cellSize += this.tableGenes.getRowMargin());
        int totalSize = cellSize * this.geneVector.size() + headerSize;
        return totalSize;
    }

    private class MyTableModel
    extends AbstractColoredTableModel {
        private GeneVector dataProvider;

        public MyTableModel(GeneVector geneVector) {
            this.dataProvider = geneVector;
        }

        public int getColumnCount() {
            return 6;
        }

        public int getRowCount() {
            return this.dataProvider.size();
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Location";
                }
                case 2: {
                    return "Cytological\nmap";
                }
                case 3: {
                    return "Position\nin location";
                }
                case 4: {
                    return "Strand";
                }
                case 5: {
                    return "Gene Id";
                }
            }
            assert (false);
            return null;
        }

        public Object getValueAt(int row, int col) {
            String output = new String();
            GeneItem geneItem = (GeneItem)this.dataProvider.elementAt(row);
            switch (col) {
                case 0: {
                    return geneItem.getName();
                }
                case 1: {
                    return geneItem.getFisierOrigine();
                }
                case 2: {
                    return geneItem.getCyto();
                }
                case 3: {
                    output = geneItem.getLocationStart() + " .. " + geneItem.getLocationEnd();
                    return output;
                }
                case 4: {
                    output = "";
                    String auxString = geneItem.isComplement() ? "(-)" : "(+)";
                    output = output + " " + auxString;
                    return output;
                }
                case 5: {
                    return geneItem.getGeneId();
                }
            }
            assert (false);
            return null;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
            }
            assert (false);
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object value, int row, int col) {
        }

        public Color getBackground(int row, int col) {
            return DrawingConstants.COLOR_TABLE_BG_GREEN;
        }

        public Color getForeground(int row, int col) {
            return null;
        }
    }
}

