/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import java.io.Serializable;
import net.sf.jasperreports.components.list.BaseListContents;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.ListContents;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardListComponent
implements Serializable,
ListComponent {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_PRINT_ORDER = "printOrder";
    public static final String PROPERTY_IGNORE_WIDTH = "ignoreWidth";
    private JRDatasetRun datasetRun;
    private ListContents contents;
    private Byte printOrder;
    private Boolean ignoreWidth;
    private transient JRPropertyChangeSupport eventSupport;

    public StandardListComponent() {
    }

    public StandardListComponent(ListComponent list, JRBaseObjectFactory baseFactory) {
        this.datasetRun = baseFactory.getDatasetRun(list.getDatasetRun());
        this.contents = new BaseListContents(list.getContents(), baseFactory);
        this.printOrder = list.getPrintOrder();
        this.ignoreWidth = list.getIgnoreWidth();
    }

    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    public void setDatasetRun(JRDatasetRun datasetRun) {
        this.datasetRun = datasetRun;
    }

    public ListContents getContents() {
        return this.contents;
    }

    public void setContents(ListContents contents) {
        this.contents = contents;
    }

    public Object clone() {
        try {
            StandardListComponent clone = (StandardListComponent)super.clone();
            clone.datasetRun = (JRDatasetRun)JRCloneUtils.nullSafeClone(this.datasetRun);
            clone.contents = (ListContents)JRCloneUtils.nullSafeClone(this.contents);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }

    public Byte getPrintOrder() {
        return this.printOrder;
    }

    public void setPrintOrder(Byte printOrder) {
        Byte old = this.printOrder;
        this.printOrder = printOrder;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_ORDER, old, this.printOrder);
    }

    public void setPrintOrder(byte printOrder) {
        this.setPrintOrder(new Byte(printOrder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        StandardListComponent standardListComponent = this;
        synchronized (standardListComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public Boolean getIgnoreWidth() {
        return this.ignoreWidth;
    }

    public void setIgnoreWidth(Boolean ignoreWidth) {
        Boolean old = this.ignoreWidth;
        this.ignoreWidth = ignoreWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_IGNORE_WIDTH, old, this.ignoreWidth);
    }

    public void setIgnoreWidth(boolean ignoreWidth) {
        this.setIgnoreWidth((Boolean)ignoreWidth);
    }
}

