/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.io.Writer;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxStyleHelper;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class XlsxCellHelper
extends BaseHelper {
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_MIDDLE = "center";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    private XlsxStyleHelper styleHelper = null;

    public XlsxCellHelper(Writer writer, XlsxStyleHelper styleHelper) {
        super(writer);
        this.styleHelper = styleHelper;
    }

    public void exportHeader(JRExporterGridCell gridCell, int rowIndex, int colIndex) {
        this.write("  <c r=\"" + XlsxCellHelper.getColumIndexLetter(colIndex) + (rowIndex + 1) + "\" s=\"" + this.styleHelper.getCellStyle(gridCell) + "\" t=\"inlineStr\">");
    }

    public void exportFooter() {
        this.write("</c>");
    }

    private void exportBackcolor(byte mode, Color backcolor) {
        if (mode == 1 && backcolor != null) {
            this.write("      <w:shd w:val=\"clear\" w:color=\"auto\"\tw:fill=\"" + JRColorUtil.getColorHexa(backcolor) + "\" />\n");
        }
    }

    private void exportAlignmentAndRotation(String verticalAlignment, String textRotation) {
        if (verticalAlignment != null) {
            this.write("      <w:vAlign w:val=\"" + verticalAlignment + "\" />\n");
        }
        if (textRotation != null) {
            this.write("   <w:textDirection w:val=\"" + textRotation + "\" />\n");
        }
    }

    private static String getTextDirection(Byte rotation) {
        String textDirection = null;
        if (rotation != null) {
            switch (rotation) {
                case 1: {
                    textDirection = "btLr";
                    break;
                }
                case 2: {
                    textDirection = "tbRl";
                    break;
                }
            }
        }
        return textDirection;
    }

    public static String getVerticalAlignment(Byte verticalAlignment) {
        if (verticalAlignment != null) {
            switch (verticalAlignment) {
                case 3: {
                    return VERTICAL_ALIGN_BOTTOM;
                }
                case 2: {
                    return VERTICAL_ALIGN_MIDDLE;
                }
            }
            return VERTICAL_ALIGN_TOP;
        }
        return null;
    }

    public static String getColumIndexLetter(int colIndex) {
        int intFirstLetter = colIndex / 676 + 64;
        int intSecondLetter = colIndex % 676 / 26 + 64;
        int intThirdLetter = colIndex % 26 + 65;
        int FirstLetter = intFirstLetter > 64 ? (int)intFirstLetter : 32;
        int SecondLetter = intSecondLetter > 64 ? (int)intSecondLetter : 32;
        char ThirdLetter = (char)intThirdLetter;
        return ("" + (char)FirstLetter + (char)SecondLetter + ThirdLetter).trim();
    }
}

