/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.exporters;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JasperViewer;
import ro.genomeartist.components.dialogs.DialogFactory;
import ro.genomeartist.gui.controller.finalresult.FinalResultItem;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingItem;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingSet;
import ro.genomeartist.gui.controller.genes.GeneItem;
import ro.genomeartist.gui.controller.genes.GeneItemWrapper;
import ro.genomeartist.gui.controller.genes.GeneVector;
import ro.genomeartist.gui.controller.query.MainResult;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.mainpanels.genes.JGeneVectorPane;
import ro.genomeartist.gui.reports.datasources.JRDataSourceFinalResult;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;

public class FinalResultExporter {
    public static void exportResultAsImage(FinalResultItem sourceResult, File destination) {
        int resultHeight = sourceResult.getImageHeight(new JLabel());
        int mappingSetHeight = 0;
        int genesHeight = 0;
        LinkedHashSet<GeneItem> geneItemSanitizer = new LinkedHashSet<GeneItem>();
        IntervalMappingSet intervalMappingSet = sourceResult.getIntervalMappingSet();
        for (IntervalMappingItem mappingItem : intervalMappingSet) {
            GeneItemWrapper geneItemWrapper = mappingItem.getGeneItemWrapper();
            mappingSetHeight += geneItemWrapper.getImageHeight(new JLabel());
            geneItemSanitizer.addAll(geneItemWrapper.getFullGeneVector());
        }
        GeneVector geneVector = new GeneVector();
        geneVector.addAll(geneItemSanitizer);
        JGeneVectorPane geneVectorPane = new JGeneVectorPane(geneVector);
        genesHeight = geneVectorPane.getSuggestedHeight();
        int canvasWidth = 800;
        int canvasHeight = resultHeight + mappingSetHeight + genesHeight;
        BufferedImage image = new BufferedImage(canvasWidth, canvasHeight, 2);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        sourceResult.paintImage(g2d, canvasWidth, resultHeight, Color.WHITE, Color.BLACK);
        g2d.translate(0, resultHeight);
        for (IntervalMappingItem mappingItem : intervalMappingSet) {
            GeneItemWrapper geneItemWrapper = mappingItem.getGeneItemWrapper();
            int itemHeight = geneItemWrapper.getImageHeight(new JLabel());
            geneItemWrapper.paintImage(g2d, canvasWidth, itemHeight, Color.WHITE, Color.BLACK);
            g2d.translate(0, itemHeight);
        }
        geneVectorPane.setPreferredSize(new Dimension(canvasWidth, genesHeight));
        geneVectorPane.setSize(geneVectorPane.getPreferredSize());
        JFrame frame = new JFrame();
        geneVectorPane.getScrollPane().setVerticalScrollBarPolicy(21);
        frame.getContentPane().add(geneVectorPane);
        frame.pack();
        frame.setSize(canvasWidth, genesHeight);
        geneVectorPane.printAll(g2d);
        frame.getContentPane().removeAll();
        frame.dispose();
        try {
            if (image != null) {
                ImageIO.write((RenderedImage)image, "png", destination);
            }
        }
        catch (IOException ex) {
            System.err.println("Could not save");
        }
    }

    public static void exportResultAsPdf(IGlobalManager globalManager, File destination, MainResult mainResult, FinalResultItem sourceResult) {
        JasperPrint jasperPrint = FinalResultExporter.fillResultReport(mainResult, sourceResult);
        try {
            JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)destination.getPath());
        }
        catch (JRException ex) {
            DialogFactory.showErrorDialog(globalManager.getTheRootFrame(), "Error", "Could not export to pdf.");
            System.err.println("Could not export to pdf");
        }
    }

    public static void printReport(MainResult mainResult, FinalResultItem sourceResult) {
        JasperPrint jasperPrint = FinalResultExporter.fillResultReport(mainResult, sourceResult);
        JasperViewer.viewReport((JasperPrint)jasperPrint, (boolean)false);
    }

    private static JasperPrint fillResultReport(MainResult mainResult, FinalResultItem sourceResult) {
        String compiledFolder = ReadOnlyConfiguration.getString("JASPER_COMPILED_FOLDER");
        String compiledPath = compiledFolder + ReadOnlyConfiguration.getString("JASPER_COMPILED_RESULT_REPORT");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("titlu", "Search Result");
        params.put("header_left", "Search Result");
        params.put("header_right", "Genome ARTIST");
        params.put("footer", mainResult.infoQuery.queryName);
        params.put("queryName", mainResult.infoQuery.queryName);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        params.put("searchDate", dateFormat.format(mainResult.infoQuery.searchDate));
        params.put("version", "Genome ARTIST 1.19");
        JRDataSourceFinalResult dataSource = new JRDataSourceFinalResult(mainResult, sourceResult);
        try {
            JasperReport jasperReport = (JasperReport)JRLoader.loadObjectFromLocation((String)compiledPath);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, params, (JRDataSource)dataSource);
            return jasperPrint;
        }
        catch (JRException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

