/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.externalcalls.actions;

import java.io.File;
import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.gui.controller.externalcalls.ExternalLink;
import ro.genomeartist.gui.controller.settings.SearchFile;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddSearchFileCallable
extends AbstractProgressCallable<Boolean> {
    private SearchFile searchFile;

    public AddSearchFileCallable(SearchFile searchFile) {
        this.searchFile = searchFile;
    }

    @Override
    public Boolean call() throws Exception {
        String baseName = this.searchFile.fileTitle;
        this.setProgressRange(0, 5);
        this.setProgressInfo("Adding " + baseName);
        String folderRaw = ReadOnlyConfiguration.getString("FOLDER_RAW");
        String numeRawNew = baseName + ".raw";
        String pathRaw = folderRaw + numeRawNew;
        File newRaw = new File(pathRaw);
        ExternalLink.copyRawFile(this.searchFile.rawLocation, newRaw);
        this.searchFile.rawLocation = newRaw;
        this.setProgressValue(100);
        this.setProgressRange(5, 95);
        AbstractProgressCallable<Boolean> runDataHashing = ExternalLink.getDataHashingCallable(newRaw);
        runDataHashing.setProgressInfoManager(this);
        runDataHashing.call();
        this.setProgressRange(95, 100);
        String folderGene = ReadOnlyConfiguration.getString("FOLDER_GENE");
        String numeGeneNew = baseName + ".gene";
        String pathGene = folderGene + numeGeneNew;
        File newGene = new File(pathGene);
        if (this.searchFile.geneLocation != null) {
            this.searchFile.geneNumber = ExternalLink.fastaToGeneFile(this.searchFile.geneLocation, newGene);
        } else {
            ExternalLink.createEmptyFile(newGene);
            this.searchFile.geneNumber = 0;
        }
        this.searchFile.geneLocation = newGene;
        this.setProgressValue(100);
        return Boolean.TRUE;
    }
}

