/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.externalcalls.actions;

import java.util.Vector;
import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.gui.controller.externalcalls.ExternalLink;
import ro.genomeartist.gui.controller.settings.SearchFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteMultipleFilesCallable
extends AbstractProgressCallable<Boolean> {
    private Vector<SearchFile> deleteFilesVector;

    public DeleteMultipleFilesCallable(Vector<SearchFile> deleteFilesVector) {
        this.deleteFilesVector = deleteFilesVector;
    }

    @Override
    public Boolean call() throws Exception {
        int filesNumber = this.deleteFilesVector.size();
        int step = 100 / filesNumber;
        int infLimit = 0;
        int supLimit = step;
        for (SearchFile searchFile : this.deleteFilesVector) {
            this.setProgressRange(infLimit, supLimit);
            AbstractProgressCallable<Boolean> deleteIndividualFile = ExternalLink.getDeleteSearchFileCallable(searchFile);
            deleteIndividualFile.setProgressInfoManager(this);
            deleteIndividualFile.call();
            infLimit = supLimit;
            supLimit += step;
        }
        return Boolean.TRUE;
    }
}

