/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.externalcalls.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.gui.controller.externalcalls.ExternalLink;
import ro.genomeartist.gui.controller.externalcalls.actions.TaggedFileConsumerCallable;
import ro.genomeartist.gui.controller.query.SearchQuery;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunSearchCallable
extends AbstractProgressCallable<Boolean> {
    SearchQuery searchQuery;
    File outputFile;

    public RunSearchCallable(SearchQuery searchQuery, File outputFile) {
        this.searchQuery = searchQuery;
        this.outputFile = outputFile;
    }

    @Override
    public Boolean call() throws Exception {
        String outputFileName = this.outputFile.getPath();
        String[] args = new String[]{ReadOnlyConfiguration.getString("clientFile"), this.searchQuery.getQueryContent(), ReadOnlyConfiguration.getString("EXPANSION_TABLE_FILE"), this.searchQuery.getQueryName(), outputFileName};
        ProcessBuilder pbuild = new ProcessBuilder(args);
        Process process = pbuild.start();
        ExternalLink.setSearchProcess(process);
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        String stopWordClient = ReadOnlyConfiguration.getString("stopWordClient");
        this.setProgressRange(0, 100);
        TaggedFileConsumerCallable taggedFileConsumer = new TaggedFileConsumerCallable(br, stopWordClient);
        taggedFileConsumer.setProgressInfoManager(this);
        taggedFileConsumer.call();
        ExternalLink.setSearchProcess(null);
        process.waitFor();
        int exitValue = process.exitValue();
        if (exitValue != 0) {
            throw new Exception("Search failed !");
        }
        return Boolean.TRUE;
    }
}

