/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.externalcalls.actions;

import java.io.BufferedReader;
import java.util.regex.Pattern;
import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.components.utils.NumberUtils;
import ro.genomeartist.gui.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedFileConsumerCallable
extends AbstractProgressCallable<Boolean> {
    private static final Pattern REGEX_TAG = Pattern.compile("^@(\\w+)[\\s]*:[\\s]*([^:]*)");
    private static final String TAG_INFO = "info";
    private static final String TAG_PROGRESS = "progress";
    private static final String TAG_ERROR = "error";
    private BufferedReader br;
    private String stopWord;

    public TaggedFileConsumerCallable(BufferedReader br, String stopWord) {
        this.br = br;
        this.stopWord = stopWord;
    }

    @Override
    public Boolean call() throws Exception {
        String line;
        while ((line = this.br.readLine()) != null && !line.startsWith(this.stopWord)) {
            String tag = StringUtils.regexFind(REGEX_TAG, line, 1);
            String value = StringUtils.regexFind(REGEX_TAG, line, 2);
            if (tag == null || value == null) continue;
            if (TAG_INFO.equals(tag)) {
                this.setProgressInfo(value);
                continue;
            }
            if (TAG_PROGRESS.equals(tag)) {
                if (!NumberUtils.isValidInteger(value)) continue;
                this.setProgressValue(Integer.valueOf(value));
                continue;
            }
            if (!TAG_ERROR.equals(tag)) continue;
            this.addErrorMessage(value);
        }
        return Boolean.TRUE;
    }
}

