/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.mainpanels.partialresult;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import ro.genomeartist.components.coloredtable.AbstractColoredTableModel;
import ro.genomeartist.components.coloredtable.JColoredTable;
import ro.genomeartist.components.headerrenderer.MultilineHeaderRenderer;
import ro.genomeartist.gui.cellrenderers.JBoldIntegerCellRenderer;
import ro.genomeartist.gui.cellrenderers.JDefferPaintCellRenderer;
import ro.genomeartist.gui.cellrenderers.JTransposonDefaultCellRenderer;
import ro.genomeartist.gui.controller.partialresult.PartialResultItem;
import ro.genomeartist.gui.controller.partialresult.PartialResultSet;
import ro.genomeartist.gui.custompaint.BoldInteger;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.dialogs.JPartialResultItemDialog;
import ro.genomeartist.gui.interfaces.IGlobalManager;

public class JPartialResultSetPane
extends JPanel {
    private PartialResultSet partialResultSet;
    private JColoredTable tablePartialResults;
    private MyTableModel tableModel;
    private int scale = 2;
    MultilineHeaderRenderer multirenderer;
    TableRowSorter<TableModel> sorter;
    IGlobalManager globalManager;
    private TableModelListener tableModelListener = new TableModelListener(){

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0 && e.getColumn() > 0) {
                JPartialResultSetPane.this.repaint();
            }
        }
    };
    private MouseAdapter clickListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int row = JPartialResultSetPane.this.sorter.convertRowIndexToModel(JPartialResultSetPane.this.tablePartialResults.rowAtPoint(e.getPoint()));
                PartialResultItem selectedItem = (PartialResultItem)JPartialResultSetPane.this.partialResultSet.elementAt(row);
                JPartialResultItemDialog dialog = new JPartialResultItemDialog(JPartialResultSetPane.this.globalManager.getTheRootFrame(), "Partial result", true, selectedItem);
                dialog.setVisible(true);
            }
        }
    };

    public JPartialResultSetPane(IGlobalManager globalManager, PartialResultSet partialResultSet) {
        this.setLayout(new BorderLayout());
        this.globalManager = globalManager;
        this.partialResultSet = partialResultSet;
        this.tableModel = new MyTableModel(partialResultSet);
        this.tableModel.addTableModelListener(this.tableModelListener);
        this.tablePartialResults = new JColoredTable(this.tableModel);
        this.tablePartialResults.setAutoResizeMode(1);
        this.tablePartialResults.setSelectionMode(0);
        this.tablePartialResults.getTableHeader().setReorderingAllowed(false);
        this.tablePartialResults.setShowHorizontalLines(true);
        this.tablePartialResults.setShowVerticalLines(true);
        this.tablePartialResults.setRowHeight(new PartialResultItem().getRecommendedHeight(this));
        this.tablePartialResults.setDefaultCellRenderer(new JTransposonDefaultCellRenderer());
        this.tablePartialResults.setDefaultRenderer(PartialResultItem.class, new JDefferPaintCellRenderer());
        this.tablePartialResults.setDefaultRenderer(BoldInteger.class, new JBoldIntegerCellRenderer());
        this.sorter = new TableRowSorter<MyTableModel>(this.tableModel);
        this.tablePartialResults.setRowSorter(this.sorter);
        this.sorter.toggleSortOrder(0);
        this.sorter.toggleSortOrder(0);
        this.tablePartialResults.addMouseListener(this.clickListener);
        this.multirenderer = new MultilineHeaderRenderer();
        this.setPrefferedWidth();
        this.add((Component)new JScrollPane(this.tablePartialResults), "Center");
    }

    private void setPrefferedWidth() {
        TableColumnModel columns = this.tablePartialResults.getColumnModel();
        TableColumn column = columns.getColumn(0);
        column.setHeaderRenderer(this.multirenderer);
        column.setPreferredWidth(10);
        column = columns.getColumn(1);
        column.setHeaderRenderer(this.multirenderer);
        column.setPreferredWidth(30);
        column = columns.getColumn(2);
        column.setHeaderRenderer(this.multirenderer);
        column.setPreferredWidth(80);
        column = columns.getColumn(3);
        column.setHeaderRenderer(this.multirenderer);
        column.setPreferredWidth(10);
        column = columns.getColumn(4);
        column.setHeaderRenderer(this.multirenderer);
        column.setPreferredWidth(400);
    }

    private class MyTableModel
    extends AbstractColoredTableModel {
        private PartialResultSet dataProvider;

        public MyTableModel(PartialResultSet dataProvider) {
            this.dataProvider = dataProvider;
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return this.dataProvider.size();
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Score";
                }
                case 1: {
                    return "Location";
                }
                case 2: {
                    return "Position";
                }
                case 3: {
                    return "Length";
                }
                case 4: {
                    return "Sequence\nMapping";
                }
            }
            assert (false);
            return null;
        }

        public Object getValueAt(int row, int col) {
            Double result = new Double(0.0);
            String output = new String();
            BigDecimal aux = new BigDecimal(1);
            PartialResultItem partialResultItem = (PartialResultItem)this.dataProvider.elementAt(row);
            switch (col) {
                case 0: {
                    return new BoldInteger(partialResultItem.getScore());
                }
                case 1: {
                    return partialResultItem.getFisierOrigine();
                }
                case 2: {
                    String complement = partialResultItem.isComplement() ? "(-)" : "(+)";
                    return partialResultItem.getPozitieStartGenom() + ".." + partialResultItem.getPozitieStopGenom() + " " + complement;
                }
                case 3: {
                    return new Integer(partialResultItem.getLengthQuery());
                }
                case 4: {
                    return partialResultItem;
                }
            }
            assert (false);
            return null;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return BoldInteger.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return Integer.class;
                }
                case 4: {
                    return PartialResultItem.class;
                }
            }
            assert (false);
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object value, int row, int col) {
        }

        public Color getBackground(int row, int col) {
            return DrawingConstants.COLOR_TABLE_BG_YELLOW;
        }

        public Color getForeground(int row, int col) {
            return null;
        }
    }
}

