/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.mainpanels.query;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.genomeartist.gui.controller.finalresult.FinalResultItem;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.custompaint.JDefferedPanel;
import ro.genomeartist.gui.dialogs.JFinalResultItemDialog;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.interfaces.ILocalManager;
import ro.genomeartist.gui.utils.MyUtils;

public class JBestResultPane
extends JPanel {
    private FinalResultItem finalResultItem;
    private IGlobalManager globalManager;
    private ILocalManager localManager;
    private static final String TEXT_TITLE = "Best result";
    private static final String TEXT_SCORE = "Score";
    private static final String TEXT_OPEN = " Open result ";
    private static final String ACTION_OPEN = "open";
    private static final int STRUT_HEIGHT = 800;
    JPanel scorePane;
    JLabel labelTextScore;
    JLabel labelValueScore;
    JPanel summaryPane;
    JPanel buttonPane;
    JButton openButton;
    ActionListener buttonListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (JBestResultPane.ACTION_OPEN.equals(cmd)) {
                JFinalResultItemDialog dialog = new JFinalResultItemDialog(JBestResultPane.this.globalManager, JBestResultPane.this.localManager, JBestResultPane.TEXT_TITLE, JBestResultPane.this.finalResultItem);
                dialog.setVisible(true);
            }
        }
    };

    public JBestResultPane(IGlobalManager globalManager, ILocalManager localManager, FinalResultItem finalResultItem) {
        this.finalResultItem = finalResultItem;
        this.globalManager = globalManager;
        this.localManager = localManager;
        if (finalResultItem != null) {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createTitledBorder(TEXT_TITLE));
            this.labelTextScore = new JLabel(TEXT_SCORE);
            MyUtils.setLabelBold(this.labelTextScore);
            this.labelValueScore = new JLabel(finalResultItem.getScore() + "");
            MyUtils.setLabelBold(this.labelValueScore);
            this.scorePane = this.createAlignedPane(this.labelTextScore, this.labelValueScore);
            this.add(this.scorePane);
            this.summaryPane = new JDefferedPanel(finalResultItem);
            this.add(this.summaryPane);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 0));
            this.openButton = new JButton();
            this.openButton.setText(TEXT_OPEN);
            this.openButton.setActionCommand(ACTION_OPEN);
            this.openButton.addActionListener(this.buttonListener);
            this.buttonPane.add(Box.createHorizontalGlue());
            this.buttonPane.add(this.openButton);
            this.buttonPane.add(Box.createHorizontalGlue());
            this.add(this.buttonPane);
            this.add(Box.createVerticalStrut(800));
        }
    }

    private JPanel createAlignedPane(JLabel label1, JLabel label2) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(label1);
        panel.add(Box.createHorizontalGlue());
        panel.add(label2);
        label2.setForeground(DrawingConstants.COLOR_GENOM_BORDER);
        return panel;
    }
}

