/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.mainpanels.settings;

import javax.swing.JTabbedPane;
import ro.genomeartist.gui.controller.settings.GeneralSettings;
import ro.genomeartist.gui.controller.settings.SearchFileSet;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.mainpanels.settings.JAlgorithmParametersPane;
import ro.genomeartist.gui.mainpanels.settings.JSearchFilesPane;

public class JSettingsPane
extends JTabbedPane {
    private GeneralSettings generalSettings;
    private static final String TEXT_PARAMS = "Parameters";
    private static final String TEXT_GENOM = "Genome files";
    private static final String TEXT_TRANSPOSON = "Transposon files";
    JAlgorithmParametersPane algorithmParamsPane;
    JSearchFilesPane genomFilesPane;
    JSearchFilesPane transposonFilesPane;
    IGlobalManager globalManager;

    public JSettingsPane(IGlobalManager globalManager, GeneralSettings generalSettings) {
        this.generalSettings = generalSettings;
        this.globalManager = globalManager;
        this.genomFilesPane = new JSearchFilesPane(globalManager, generalSettings.genomFiles, false);
        this.add(TEXT_GENOM, this.genomFilesPane);
        this.transposonFilesPane = new JSearchFilesPane(globalManager, generalSettings.transposonFiles, true);
        this.add(TEXT_TRANSPOSON, this.transposonFilesPane);
        this.algorithmParamsPane = new JAlgorithmParametersPane(generalSettings.algorithmParams);
        this.add(TEXT_PARAMS, this.algorithmParamsPane);
    }

    public boolean fireActionApplyAlgorithmParams() {
        return this.algorithmParamsPane.commitChanges();
    }

    public boolean fireActionApplyFileParams() {
        if (this.genomFilesPane.hasChanged() || this.transposonFilesPane.hasChanged()) {
            SearchFileSet genomSet = this.genomFilesPane.getSearchFileSet();
            SearchFileSet transposonSet = this.transposonFilesPane.getSearchFileSet();
            SearchFileSet indexFisiere = new SearchFileSet(genomSet);
            indexFisiere.addAll(transposonSet);
            indexFisiere.saveToFile();
            return true;
        }
        return false;
    }
}

