/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.reports.datasources;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import ro.genomeartist.gui.controller.finalresult.FinalResultItem;
import ro.genomeartist.gui.controller.finalresult.FinalResultItemAlignment;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingItem;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingSet;
import ro.genomeartist.gui.controller.genes.GeneItem;
import ro.genomeartist.gui.controller.genes.GeneItemWrapper;
import ro.genomeartist.gui.controller.genes.GeneVector;
import ro.genomeartist.gui.controller.query.InfoQuery;
import ro.genomeartist.gui.controller.query.MainResult;
import ro.genomeartist.gui.custompaint.ImageManipulation;
import ro.genomeartist.gui.custompaint.ImageVector;
import ro.genomeartist.gui.reports.datasources.JRDataSourceImageVector;
import ro.genomeartist.gui.reports.datasources.JRDataSourceSubGenes;
import ro.genomeartist.gui.reports.datasources.JRDataSourceSubQuery;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;

public class JRDataSourceFinalResult
implements JRDataSource {
    private static final int LIMIT = 5;
    private int counter = 0;
    MainResult mainResult;
    FinalResultItem sourceResult;
    JRDataSource subreport_query_data;
    JasperReport subreport_query_engine;
    JRDataSource subreport_mapping_data;
    JasperReport subreport_mapping_engine;
    JRDataSource subreport_smith_data;
    JasperReport subreport_smith_engine;
    JRDataSource subreport_positioning_data;
    JasperReport subreport_positioning_engine;
    JRDataSource subreport_genes_data;
    JasperReport subreport_genes_engine;

    public JRDataSourceFinalResult(MainResult mainResult, FinalResultItem sourceResult) {
        this.mainResult = mainResult;
        this.sourceResult = sourceResult;
        this.loadQueryReport();
        this.loadMappingReport();
        this.loadSmithReport();
        this.loadPositioningReport();
        this.loadGenesReport();
    }

    private void loadQueryReport() {
        String subreportFolder = ReadOnlyConfiguration.getString("JASPER_COMPILED_FOLDER");
        String subreportPath = subreportFolder + ReadOnlyConfiguration.getString("JASPER_COMPILED_SUB_QUERY");
        try {
            this.subreport_query_data = JRDataSourceFinalResult.getDataSourceQuery(this.mainResult.infoQuery);
            this.subreport_query_engine = (JasperReport)JRLoader.loadObjectFromLocation((String)subreportPath);
        }
        catch (JRException ex) {
            Logger.getLogger(JRDataSourceFinalResult.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadMappingReport() {
        String subreportFolder = ReadOnlyConfiguration.getString("JASPER_COMPILED_FOLDER");
        String subreportPath = subreportFolder + ReadOnlyConfiguration.getString("JASPER_COMPILED_SUB_MAPPING");
        try {
            this.subreport_mapping_data = JRDataSourceFinalResult.getDataSourceMapping(this.sourceResult);
            this.subreport_mapping_engine = (JasperReport)JRLoader.loadObjectFromLocation((String)subreportPath);
        }
        catch (JRException ex) {
            Logger.getLogger(JRDataSourceFinalResult.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadSmithReport() {
        String subreportFolder = ReadOnlyConfiguration.getString("JASPER_COMPILED_FOLDER");
        String subreportPath = subreportFolder + ReadOnlyConfiguration.getString("JASPER_COMPILED_SUB_SMITH_WATERMAN");
        try {
            this.subreport_smith_data = JRDataSourceFinalResult.getDataSourceSmithWaterman(this.sourceResult);
            this.subreport_smith_engine = (JasperReport)JRLoader.loadObjectFromLocation((String)subreportPath);
        }
        catch (JRException ex) {
            Logger.getLogger(JRDataSourceFinalResult.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadPositioningReport() {
        String subreportFolder = ReadOnlyConfiguration.getString("JASPER_COMPILED_FOLDER");
        String subreportPath = subreportFolder + ReadOnlyConfiguration.getString("JASPER_COMPILED_SUB_POSITIONING");
        try {
            this.subreport_positioning_data = JRDataSourceFinalResult.getDataSourcePositioning(this.sourceResult);
            this.subreport_positioning_engine = (JasperReport)JRLoader.loadObjectFromLocation((String)subreportPath);
        }
        catch (JRException ex) {
            Logger.getLogger(JRDataSourceFinalResult.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadGenesReport() {
        String subreportFolder = ReadOnlyConfiguration.getString("JASPER_COMPILED_FOLDER");
        String subreportPath = subreportFolder + ReadOnlyConfiguration.getString("JASPER_COMPILED_SUB_GENES");
        try {
            this.subreport_genes_data = JRDataSourceFinalResult.getDataSourceGenes(this.sourceResult);
            this.subreport_genes_engine = (JasperReport)JRLoader.loadObjectFromLocation((String)subreportPath);
        }
        catch (JRException ex) {
            Logger.getLogger(JRDataSourceFinalResult.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static JRDataSource getDataSourceQuery(InfoQuery infoQuery) {
        return new JRDataSourceSubQuery(infoQuery);
    }

    public static JRDataSource getDataSourceMapping(FinalResultItem sourceResult) {
        int imageWidth = 555;
        int imageHeight = sourceResult.getImageHeight(new JLabel());
        BufferedImage mappedImage = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D g2d = (Graphics2D)mappedImage.getGraphics();
        sourceResult.paintImage(g2d, imageWidth, imageHeight, Color.WHITE, Color.BLACK);
        ImageVector splitedImages = ImageManipulation.splitImage(mappedImage, 150);
        return new JRDataSourceImageVector(splitedImages);
    }

    public static JRDataSource getDataSourceSmithWaterman(FinalResultItem sourceResult) {
        FinalResultItemAlignment alignment = new FinalResultItemAlignment(sourceResult);
        BufferedImage alignmentImage = alignment.exportAsImage(555, Color.WHITE, Color.BLACK);
        ImageVector splitedImages = ImageManipulation.splitImage(alignmentImage, 90);
        return new JRDataSourceImageVector(splitedImages);
    }

    public static JRDataSource getDataSourcePositioning(FinalResultItem sourceResult) {
        IntervalMappingSet intervalMappingSet = sourceResult.getIntervalMappingSet();
        Iterator iteratorMapping = intervalMappingSet.iterator();
        iteratorMapping = intervalMappingSet.iterator();
        ImageVector images = new ImageVector();
        while (iteratorMapping.hasNext()) {
            IntervalMappingItem mappingItem = (IntervalMappingItem)iteratorMapping.next();
            GeneItemWrapper geneItemWrapper = mappingItem.getGeneItemWrapper();
            int itemHeight = geneItemWrapper.getImageHeight(new JLabel());
            BufferedImage bufferedImage = new BufferedImage(555, itemHeight, 2);
            Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
            geneItemWrapper.paintImage(g2d, 555, itemHeight, Color.WHITE, Color.BLACK);
            images.add(bufferedImage);
        }
        BufferedImage mergedImage = ImageManipulation.joinImages(images);
        ImageVector splitedImages = ImageManipulation.splitImage(mergedImage, 60);
        return new JRDataSourceImageVector(splitedImages);
    }

    public static JRDataSource getDataSourceGenes(FinalResultItem sourceResult) {
        LinkedHashSet<GeneItem> geneItemSanitizer = new LinkedHashSet<GeneItem>();
        IntervalMappingSet intervalMappingSet = sourceResult.getIntervalMappingSet();
        for (IntervalMappingItem mappingItem : intervalMappingSet) {
            GeneItemWrapper geneItemWrapper = mappingItem.getGeneItemWrapper();
            geneItemSanitizer.addAll(geneItemWrapper.getFullGeneVector());
        }
        GeneVector geneVector = new GeneVector();
        geneVector.addAll(geneItemSanitizer);
        Collections.sort(geneVector);
        return new JRDataSourceSubGenes(geneVector);
    }

    public boolean next() throws JRException {
        if (this.counter < 5) {
            ++this.counter;
            return true;
        }
        return false;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        int scale = 2;
        switch (this.counter) {
            case 1: {
                if ("subreport_data".equals(fieldName)) {
                    return this.subreport_query_data;
                }
                if ("subreport_engine".equals(fieldName)) {
                    return this.subreport_query_engine;
                }
                throw new JRException("No field with specified name");
            }
            case 2: {
                if ("subreport_data".equals(fieldName)) {
                    return this.subreport_mapping_data;
                }
                if ("subreport_engine".equals(fieldName)) {
                    return this.subreport_mapping_engine;
                }
                throw new JRException("No field with specified name");
            }
            case 3: {
                if ("subreport_data".equals(fieldName)) {
                    return this.subreport_smith_data;
                }
                if ("subreport_engine".equals(fieldName)) {
                    return this.subreport_smith_engine;
                }
                throw new JRException("No field with specified name");
            }
            case 4: {
                if ("subreport_data".equals(fieldName)) {
                    return this.subreport_positioning_data;
                }
                if ("subreport_engine".equals(fieldName)) {
                    return this.subreport_positioning_engine;
                }
                throw new JRException("No field with specified name");
            }
            case 5: {
                if ("subreport_data".equals(fieldName)) {
                    return this.subreport_genes_data;
                }
                if ("subreport_engine".equals(fieldName)) {
                    return this.subreport_genes_engine;
                }
                throw new JRException("No field with specified name");
            }
        }
        return null;
    }
}

