/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.reports.datasources;

import java.util.Iterator;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import ro.genomeartist.gui.controller.genes.GeneItem;
import ro.genomeartist.gui.controller.genes.GeneVector;

public class JRDataSourceSubGenes
implements JRDataSource {
    private GeneVector geneVector;
    private Iterator<GeneItem> iterator;
    private GeneItem geneItem;

    public JRDataSourceSubGenes(GeneVector geneVector) {
        this.geneVector = geneVector;
        this.iterator = geneVector.iterator();
    }

    public boolean next() throws JRException {
        if (this.iterator.hasNext()) {
            this.geneItem = this.iterator.next();
            return true;
        }
        return false;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        int scale = 2;
        if ("sub_genes_name".equals(fieldName)) {
            return this.geneItem.getName();
        }
        if ("sub_genes_location".equals(fieldName)) {
            return this.geneItem.getFisierOrigine();
        }
        if ("sub_genes_cyto".equals(fieldName)) {
            return this.geneItem.getCyto();
        }
        if ("sub_genes_position".equals(fieldName)) {
            return this.geneItem.getLocationStart() + ".." + this.geneItem.getLocationEnd();
        }
        if ("sub_genes_strand".equals(fieldName)) {
            if (this.geneItem.isComplement()) {
                return "(-)";
            }
            return "(+)";
        }
        if ("sub_genes_id".equals(fieldName)) {
            return this.geneItem.getGeneId();
        }
        System.out.println("fieldName = " + fieldName);
        throw new JRException("No field with specified name");
    }
}

