/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import ro.genomeartist.gui.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNAUtils {
    public static String reverseComplementSequence(String sequence) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < sequence.length(); ++i) {
            char c = sequence.charAt(i);
            stringBuilder.append(DNAUtils.complementNucleotide(c));
        }
        return stringBuilder.reverse().toString();
    }

    public static List<String> reverseComplementSequences(List<String> sequences) {
        LinkedList<String> reverseComplementedSequences = new LinkedList<String>();
        for (String sequence : sequences) {
            reverseComplementedSequences.add(DNAUtils.reverseComplementSequence(sequence));
        }
        return reverseComplementedSequences;
    }

    public static List<String> extractCleanSequences(String content) {
        String squeezedContent = StringUtils.squeezeString(content);
        List<String> sequences = squeezedContent.startsWith(">") || squeezedContent.startsWith(";") ? DNAUtils.getSequencesFromFasta(content) : (squeezedContent.contains("ORIGIN") && squeezedContent.endsWith("//") ? DNAUtils.getSequencesFromGenbank(content) : DNAUtils.getSequencesFromRawInput(content));
        LinkedList<String> cleanedSequences = new LinkedList<String>();
        for (String string : sequences) {
            cleanedSequences.add(DNAUtils.cleanString(string));
        }
        return cleanedSequences;
    }

    private static List<String> getSequencesFromFasta(String content) {
        LinkedList<String> sequences = new LinkedList<String>();
        String buffer = "";
        StringTokenizer st = new StringTokenizer(content, "\n", false);
        while (st.hasMoreElements()) {
            String auxString = StringUtils.squeezeString(st.nextToken());
            if (auxString.startsWith(">")) {
                if (!buffer.isEmpty()) {
                    sequences.add(buffer);
                }
                buffer = "";
                continue;
            }
            if (auxString.startsWith(";")) continue;
            buffer = buffer + auxString;
        }
        if (!buffer.isEmpty()) {
            sequences.add(buffer);
        }
        return sequences;
    }

    private static List<String> getSequencesFromGenbank(String content) {
        LinkedList<String> sequences = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(content, "\n", false);
        boolean foundOrigin = false;
        String buffer = "";
        while (st.hasMoreElements()) {
            String auxString = StringUtils.squeezeString(st.nextToken());
            if (auxString.toLowerCase().startsWith("origin")) {
                if (!buffer.isEmpty()) {
                    sequences.add(buffer);
                }
                foundOrigin = true;
                buffer = auxString.substring("ORIGIN".length());
                continue;
            }
            if (auxString.startsWith("//")) {
                foundOrigin = false;
                continue;
            }
            if (!foundOrigin) continue;
            buffer = buffer + auxString;
        }
        if (!buffer.isEmpty()) {
            sequences.add(buffer);
        }
        return sequences;
    }

    private static List<String> getSequencesFromRawInput(String content) {
        LinkedList<String> sequences = new LinkedList<String>();
        String marker = "#";
        String markedContent = content.replaceAll("\n\\S*\n", "\n#\n");
        StringTokenizer st = new StringTokenizer(markedContent, "\n", false);
        String buffer = "";
        while (st.hasMoreElements()) {
            String auxString = StringUtils.squeezeString(st.nextToken());
            if (auxString.startsWith(marker)) {
                if (!buffer.isEmpty()) {
                    sequences.add(buffer);
                }
                buffer = "";
                continue;
            }
            buffer = buffer + auxString;
        }
        if (!buffer.isEmpty()) {
            sequences.add(buffer);
        }
        return sequences;
    }

    private static String cleanString(String sequence) {
        String result = new String();
        for (int i = 0; i < sequence.length(); ++i) {
            char c = sequence.charAt(i);
            if (!DNAUtils.isNucleotide(c)) continue;
            result = result + DNAUtils.toNucleotide(c);
        }
        return result;
    }

    public static boolean isNucleotide(char c) {
        switch (c) {
            case '.': 
            case 'A': 
            case 'C': 
            case 'G': 
            case 'N': 
            case 'T': 
            case 'a': 
            case 'c': 
            case 'g': 
            case 'n': 
            case 't': {
                return true;
            }
        }
        return false;
    }

    public static char toNucleotide(char c) {
        switch (c) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'T': 
            case 'a': 
            case 'c': 
            case 'g': 
            case 't': {
                return c;
            }
        }
        return 'N';
    }

    public static char complementNucleotide(char c) {
        switch (c) {
            case 'A': 
            case 'a': {
                return 'T';
            }
            case 'C': 
            case 'c': {
                return 'G';
            }
            case 'G': 
            case 'g': {
                return 'C';
            }
            case 'T': 
            case 't': {
                return 'A';
            }
            case 'N': 
            case 'n': {
                return 'N';
            }
        }
        return c;
    }
}

