/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReadOnlyConfiguration {
    private static Hashtable _registry = new Hashtable();
    private static final String HASHNAME = "_readonly_hash";
    public static final String CONFIGFILE = "config.txt";

    protected ReadOnlyConfiguration() {
    }

    public static Hashtable getInstance() {
        return (Hashtable)_registry.get(HASHNAME);
    }

    public static void init() {
        ReadOnlyConfiguration.loadFromFile(CONFIGFILE);
    }

    public static void loadFromFile(String configFile) {
        try {
            String line;
            Hashtable hash = (Hashtable)_registry.get(HASHNAME);
            BufferedReader fileReader = new BufferedReader(new FileReader(configFile));
            while ((line = fileReader.readLine()) != null) {
                if (line.startsWith("#") || line.indexOf("=") == -1) continue;
                StringTokenizer st = new StringTokenizer(line, "=");
                String leftToken = st.nextToken();
                String rightToken = st.nextToken();
                String key = new String();
                StringTokenizer aux = new StringTokenizer(leftToken, " \t");
                if (aux.hasMoreTokens()) {
                    key = key + aux.nextToken();
                }
                while (aux.hasMoreTokens()) {
                    key = key + " " + aux.nextToken();
                }
                String value = new String();
                aux = new StringTokenizer(rightToken, " \t");
                if (aux.hasMoreTokens()) {
                    value = value + aux.nextToken();
                }
                while (aux.hasMoreTokens()) {
                    value = value + " " + aux.nextToken();
                }
                hash.put(key, value);
            }
            fileReader.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ResultSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ResultSet.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void saveToFile(String configFile) {
        try {
            Hashtable hash = (Hashtable)_registry.get(HASHNAME);
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(configFile, false));
            Set set = hash.entrySet();
            for (Map.Entry entry : set) {
                fileWriter.write((String)entry.getKey());
                fileWriter.write(" = ");
                fileWriter.write(entry.getValue().toString());
                fileWriter.newLine();
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ReadOnlyConfiguration.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void put(String key, Object value) {
        Hashtable hash = (Hashtable)_registry.get(HASHNAME);
        hash.put(key, value);
    }

    public static Object get(String key) {
        Hashtable hash = (Hashtable)_registry.get(HASHNAME);
        return hash.get(key);
    }

    public static String getString(String key) {
        Hashtable hash = (Hashtable)_registry.get(HASHNAME);
        return (String)hash.get(key);
    }

    public static void main(String[] args) {
        ReadOnlyConfiguration.init();
        System.out.println(ReadOnlyConfiguration.get("cleanerFile"));
        ReadOnlyConfiguration.put("SCALE", new Integer(4));
        ReadOnlyConfiguration.saveToFile("confignew.txt");
    }

    static {
        Hashtable hashtable = new Hashtable();
        _registry.put(HASHNAME, hashtable);
    }
}

