/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.utils;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final int MINUTES_2_SECONDS = 60;
    private static final int HOURS_2_SECONDS = 3600;

    public static String timeToString(int time) {
        String strMinute;
        String strHour;
        String result = "";
        boolean hasHours = false;
        boolean hasMinutes = false;
        int hours = time / 3600;
        int rest = time % 3600;
        int minutes = rest / 60;
        int seconds = rest % 60;
        if (hours > 0) {
            strHour = hours + "";
            hasHours = true;
        } else {
            strHour = "";
            hasHours = false;
        }
        if (hasHours) {
            strMinute = minutes + "";
            hasMinutes = true;
        } else if (minutes > 0) {
            strMinute = minutes + "";
            hasMinutes = true;
        } else {
            strMinute = "";
            hasMinutes = false;
        }
        String strSecond = seconds + "";
        if (hasHours) {
            strMinute = StringUtils.padWithZero(strMinute, 2);
        }
        if (hasMinutes) {
            strSecond = StringUtils.padWithZero(strSecond, 2);
        }
        if (hasHours) {
            result = result + strHour + "h ";
        }
        if (hasMinutes) {
            result = result + strMinute + "m ";
        }
        result = result + strSecond + "s";
        return result;
    }

    public static String padWithZero(String string, int count) {
        String padding = "";
        for (int i = string.length(); i < count; ++i) {
            padding = padding + "0";
        }
        return padding + string;
    }

    public static String regexFind(Pattern pattern, String searchString) {
        return StringUtils.regexFind(pattern, searchString, 0);
    }

    public static String regexFind(Pattern pattern, String searchString, int group) {
        Matcher matcher = pattern.matcher(searchString);
        boolean found = false;
        if (matcher.find()) {
            found = true;
            return matcher.group(group);
        }
        return null;
    }

    public static String sanitizeFilename(String filename) {
        String plainText = StringUtils.sanitizeName(filename);
        return plainText.replaceAll(" ", "_");
    }

    public static String sanitizeName(String name) {
        StringTokenizer st = new StringTokenizer(name, "/\\\t\n;,><", false);
        String result = "";
        while (st.hasMoreElements()) {
            result = result + st.nextElement();
        }
        return result;
    }

    public static String squeezeString(String sequence) {
        StringTokenizer st = new StringTokenizer(sequence, " \t", false);
        String result = "";
        while (st.hasMoreElements()) {
            result = result + st.nextElement();
        }
        return result;
    }

    public static boolean areEqual(String string1, String string2) {
        return string1 == null ? string2 == null : (string2 == null ? false : string1.equals(string2));
    }
}

