/*
 * Decompiled with CFR 0.152.
 */
package testing.probability;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import testing.probability.EventVector;
import testing.probability.OverlappedWindowsProbability;
import testing.probability.ProbabilityAlgorithm;

public class GeneralProbabilityEvaluator {
    private static final int PRECISION = 10;

    public static boolean validateAlgorithm(ProbabilityAlgorithm probabilityAlgorithm) throws IOException {
        return GeneralProbabilityEvaluator.validateAlgorithm(probabilityAlgorithm, false);
    }

    public static boolean validateAlgorithm(ProbabilityAlgorithm probabilityAlgorithm, boolean shouldPrint) throws IOException {
        BigDecimal favorableCasesProbability = BigDecimal.ZERO;
        FileWriter fileWriter = new FileWriter("probability.txt");
        PrintWriter externalFile = new PrintWriter(fileWriter);
        EventVector eventVector = new EventVector(probabilityAlgorithm.getNumberOfEvents(), probabilityAlgorithm.getHeadProbability());
        int totalNumberOfCases = (int)Math.pow(2.0, probabilityAlgorithm.getNumberOfEvents());
        for (int i = 0; i < totalNumberOfCases; ++i) {
            boolean isFavorable = probabilityAlgorithm.isFavorableEventVector(eventVector);
            BigDecimal eventVectorProbability = BigDecimal.ZERO;
            if (shouldPrint) {
                eventVectorProbability = eventVector.computeVectorProbability();
                externalFile.println("\"" + eventVector + "\";" + eventVectorProbability.setScale(10, RoundingMode.HALF_EVEN) + ";" + isFavorable + ";");
            } else if (isFavorable) {
                eventVectorProbability = eventVector.computeVectorProbability();
            }
            if (isFavorable) {
                favorableCasesProbability = favorableCasesProbability.add(eventVectorProbability);
            }
            eventVector.increment();
        }
        externalFile.close();
        double algorithmProbability = probabilityAlgorithm.computeProbability();
        double favorableProbability = favorableCasesProbability.doubleValue();
        System.out.println("favorableCasesProbability = " + favorableCasesProbability);
        System.out.println("computedProbability = " + algorithmProbability);
        return GeneralProbabilityEvaluator.areEqual(algorithmProbability, favorableProbability, 10);
    }

    private static boolean areEqual(double x, double y, int precision) {
        double difference = x - y;
        difference *= Math.pow(10.0, precision);
        return (difference = (double)Math.round(difference)) == 0.0;
    }

    public static void main(String[] args) throws IOException {
        int n = 20;
        int k = 10;
        double p = 0.83;
        System.out.println("~~~~~~ Setarile initiale ~~~~~~~~");
        OverlappedWindowsProbability probabilityAlgorithm = new OverlappedWindowsProbability(n, k, p);
        System.out.println("numberOfEvents = " + probabilityAlgorithm.getNumberOfEvents());
        System.out.println("numberOfConsecutiveHeads = " + probabilityAlgorithm.getNumberOfConsecutiveHeads());
        System.out.println("headProbability = " + probabilityAlgorithm.getHeadProbability());
        System.out.println("");
        System.out.println("~~~~~~ Testing validateAlgorithm() ~~~~~~~~");
        long start_time = System.currentTimeMillis();
        boolean result = GeneralProbabilityEvaluator.validateAlgorithm(probabilityAlgorithm);
        long time = System.currentTimeMillis();
        long res_time = time - start_time;
        System.out.println("validateAlgorithm = " + result);
        System.out.println("time = " + res_time);
    }
}

