/*
 * Decompiled with CFR 0.152.
 */
package testing.probability;

import testing.probability.EventVector;
import testing.probability.ProbabilityAlgorithm;

public class NonOverlappedWindowsProbability
extends ProbabilityAlgorithm {
    public NonOverlappedWindowsProbability(int numberOfEvents, int numberOfConsecutiveHeads, double headProbability) {
        super(numberOfEvents, numberOfConsecutiveHeads, headProbability);
    }

    public boolean isFavorableEventVector(EventVector eventVector) {
        int numberOfWindows = (int)Math.floor((double)this.numberOfEvents / (double)this.numberOfConsecutiveHeads);
        for (int i = 0; i < numberOfWindows; ++i) {
            boolean windowValue = true;
            for (int j = 0; j < this.numberOfConsecutiveHeads; ++j) {
                windowValue = windowValue && eventVector.getEventAt(i * this.numberOfConsecutiveHeads + j);
            }
            if (!windowValue) continue;
            return true;
        }
        return false;
    }

    public double computeProbability() {
        double e1 = Math.pow(this.headProbability, this.numberOfConsecutiveHeads);
        double e2 = 1.0 - e1;
        int numberOfWindows = (int)Math.floor((double)this.numberOfEvents / (double)this.numberOfConsecutiveHeads);
        double e3 = Math.pow(e2, numberOfWindows);
        double result = 1.0 - e3;
        return result;
    }

    public static void main(String[] args) {
        int n = 40;
        int k = 10;
        double p = 0.81;
        System.out.println("~~~~~~ Setarile initiale ~~~~~~~~");
        NonOverlappedWindowsProbability probabilityAlgorithm = new NonOverlappedWindowsProbability(n, k, p);
        System.out.println("numberOfEvents = " + probabilityAlgorithm.getNumberOfEvents());
        System.out.println("numberOfConsecutiveHeads = " + probabilityAlgorithm.getNumberOfConsecutiveHeads());
        System.out.println("headProbability = " + probabilityAlgorithm.getHeadProbability());
        System.out.println("");
        System.out.println("~~~~~~ Testing isFavorableEventVector() ~~~~~~~~");
        EventVector eventVector = new EventVector(n, p);
        int offset = 10;
        for (int i = 0; i < k; ++i) {
            eventVector.setEventAt(i + offset, true);
        }
        boolean isFavorableEventVector = ((ProbabilityAlgorithm)probabilityAlgorithm).isFavorableEventVector(eventVector);
        System.out.println(eventVector);
        System.out.println("isFavorableEventVector = " + isFavorableEventVector);
        System.out.println("");
        System.out.println("~~~~~~ Testing computeProbability() ~~~~~~~~");
        double result = 0.0;
        long start_time = System.currentTimeMillis();
        result = ((ProbabilityAlgorithm)probabilityAlgorithm).computeProbability();
        long time = System.currentTimeMillis();
        long res_time = time - start_time;
        System.out.println("result = " + result);
        System.out.println("time = " + res_time);
    }
}

