/*
 * Decompiled with CFR 0.152.
 */
package testing.probability;

import testing.probability.EventVector;
import testing.probability.ProbabilityAlgorithm;

public class OverlappedWindowsProbability
extends ProbabilityAlgorithm {
    public OverlappedWindowsProbability(int numberOfEvents, int numberOfConsecutiveHeads, double headProbability) {
        super(numberOfEvents, numberOfConsecutiveHeads, headProbability);
    }

    public boolean isFavorableEventVector(EventVector eventVector) {
        int maxConsecutiveRuns = 0;
        int counter = 0;
        for (int i = 0; i < eventVector.getNumberOfEvents(); ++i) {
            if (eventVector.getEventAt(i)) {
                if (++counter <= maxConsecutiveRuns) continue;
                maxConsecutiveRuns = counter;
                continue;
            }
            counter = 0;
        }
        return maxConsecutiveRuns >= this.numberOfConsecutiveHeads;
    }

    public double computeProbability() {
        double minHeads = this.numberOfConsecutiveHeads;
        double[] computedProbability = new double[this.numberOfEvents + 1];
        computedProbability[0] = 0.0;
        for (int i = 1; i <= this.numberOfEvents; ++i) {
            double intermediateResult;
            if (this.numberOfConsecutiveHeads > i) {
                intermediateResult = 0.0;
            } else {
                intermediateResult = Math.pow(this.headProbability, minHeads);
                for (int j = 1; j < this.numberOfConsecutiveHeads + 1; ++j) {
                    double auxDouble = Math.pow(this.headProbability, j - 1) * (1.0 - this.headProbability);
                    double auxProbability = i < j ? 0.0 : computedProbability[i - j];
                    intermediateResult += auxDouble * auxProbability;
                }
            }
            computedProbability[i] = intermediateResult;
        }
        return computedProbability[this.numberOfEvents];
    }

    public static void main(String[] args) {
        int n = 40;
        int k = 10;
        double p = 0.81;
        System.out.println("~~~~~~ Setarile initiale ~~~~~~~~");
        OverlappedWindowsProbability probabilityAlgorithm = new OverlappedWindowsProbability(n, k, p);
        System.out.println("numberOfEvents = " + probabilityAlgorithm.getNumberOfEvents());
        System.out.println("numberOfConsecutiveHeads = " + probabilityAlgorithm.getNumberOfConsecutiveHeads());
        System.out.println("headProbability = " + probabilityAlgorithm.getHeadProbability());
        System.out.println("");
        System.out.println("~~~~~~ Testing isFavorableEventVector() ~~~~~~~~");
        EventVector eventVector = new EventVector(n, p);
        int offset = 10;
        for (int i = 0; i < k; ++i) {
            eventVector.setEventAt(i + offset, true);
        }
        boolean isFavorableEventVector = ((ProbabilityAlgorithm)probabilityAlgorithm).isFavorableEventVector(eventVector);
        System.out.println(eventVector);
        System.out.println("isFavorableEventVector = " + isFavorableEventVector);
        System.out.println("");
        System.out.println("~~~~~~ Testing computeProbability() ~~~~~~~~");
        double result = 0.0;
        long start_time = System.currentTimeMillis();
        result = ((ProbabilityAlgorithm)probabilityAlgorithm).computeProbability();
        long time = System.currentTimeMillis();
        long res_time = time - start_time;
        System.out.println("result = " + result);
        System.out.println("time = " + res_time);
    }
}

