/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.glasspane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JPanel;
import ro.genomeartist.components.glasspane.IDoScreenshot;

public class JGlasspaneContainer
extends JPanel {
    BufferedImage fakeScreen;
    Component window;
    IDoScreenshot parent;
    MouseListener mouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    };
    MouseMotionListener mousemotionListener = new MouseMotionListener(){

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    };
    ComponentListener componentListener = new ComponentListener(){

        @Override
        public void componentResized(ComponentEvent e) {
            JGlasspaneContainer.this.parent.refresh();
            JGlasspaneContainer.this.fakeScreen = JGlasspaneContainer.this.parent.takeScreenshot();
            JGlasspaneContainer.this.centerWindow();
            JGlasspaneContainer.this.repaint();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    };

    public JGlasspaneContainer(Component window, IDoScreenshot parent) {
        this.setLayout(null);
        this.setOpaque(false);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mousemotionListener);
        this.addComponentListener(this.componentListener);
        this.fakeScreen = null;
        this.parent = parent;
        this.window = window;
        this.add(window);
    }

    public void centerWindow() {
        if (this.window != null) {
            int panelwidth = this.getWidth();
            int panelheight = this.getHeight();
            int objwidth = this.window.getWidth();
            int objheight = this.window.getHeight();
            this.window.setBounds((panelwidth - objwidth) / 2, (panelheight - objheight) / 2, objwidth, objheight);
        }
    }

    public void setFakeScreen(BufferedImage image) {
        this.fakeScreen = image;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.fakeScreen != null) {
            float[] my_kernel = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f};
            ConvolveOp op = new ConvolveOp(new Kernel(3, 3, my_kernel));
            BufferedImage img = op.filter(this.fakeScreen, null);
            g.drawImage(img, 0, 0, null);
        }
        Graphics2D g2d = (Graphics2D)g;
        float alpha = 0.1f;
        Color color = new Color(0.0f, 0.0f, 1.0f, alpha);
        g2d.setPaint(color);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }
}

