/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.utils;

import java.awt.Color;
import java.awt.Graphics2D;

public class GraphicRenderingUtils {
    private static final int OFFSET_COLOR = 10;

    public static void drawEditableBackground(Graphics2D g2d, Color leftColor, Color rightColor, int width, int height, int iconWidth, boolean isReversed) {
        Color oldColor = g2d.getColor();
        g2d.setColor(rightColor);
        g2d.fillRect(0, 0, width, height);
        Color intermediateColor = GraphicRenderingUtils.colorAverage(leftColor, rightColor);
        g2d.setColor(intermediateColor);
        if (isReversed) {
            g2d.fillRect(width - iconWidth, 0, iconWidth, height);
        } else {
            g2d.fillRect(0, 0, iconWidth, height);
        }
        g2d.setColor(oldColor);
    }

    public static Color darkenColor(Color color) {
        return GraphicRenderingUtils.darkenColor(color, 10);
    }

    public static Color darkenColor(Color color, int offset) {
        return new Color(Math.max(color.getRed() - offset, 0), Math.max(color.getGreen() - offset, 0), Math.max(color.getBlue() - offset, 0));
    }

    public static Color lightenColor(Color color) {
        return GraphicRenderingUtils.lightenColor(color, 10);
    }

    public static Color lightenColor(Color color, int offset) {
        return new Color(Math.min(color.getRed() + offset, 255), Math.min(color.getGreen() + offset, 255), Math.min(color.getBlue() + offset, 255));
    }

    public static Color colorAverage(Color color1, Color color2) {
        int redValue = (color1.getRed() + color2.getRed()) / 2;
        int greenValue = (color1.getGreen() + color2.getGreen()) / 2;
        int blueValue = (color1.getBlue() + color2.getBlue()) / 2;
        return new Color(redValue, greenValue, blueValue);
    }

    public static Color colorShift(Color colorSource, Color colorDestination) {
        int colorIntensity2;
        int colorIntensity1 = GraphicRenderingUtils.getColorIntensity(colorSource);
        if (colorIntensity1 > (colorIntensity2 = GraphicRenderingUtils.getColorIntensity(colorDestination))) {
            return GraphicRenderingUtils.darkenColor(colorSource, 40);
        }
        return GraphicRenderingUtils.lightenColor(colorSource, 40);
    }

    public static Color colorShift(Color colorSource, Color colorDestination, int offset) {
        int colorIntensity2;
        int colorIntensity1 = GraphicRenderingUtils.getColorIntensity(colorSource);
        if (colorIntensity1 > (colorIntensity2 = GraphicRenderingUtils.getColorIntensity(colorDestination))) {
            return GraphicRenderingUtils.darkenColor(colorSource, offset);
        }
        return GraphicRenderingUtils.lightenColor(colorSource, offset);
    }

    public static int getColorIntensity(Color color) {
        return color.getRed() + color.getGreen() + color.getBlue();
    }
}

