/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.utils;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class WindowUtilities {
    private static Frame PHONY_FRAME = null;

    private static Frame getPhonyFrame() {
        if (PHONY_FRAME == null) {
            PHONY_FRAME = new Frame("phony");
        }
        return PHONY_FRAME;
    }

    public static Frame getRootFrame(Component c) {
        if (c != null) {
            Window window = SwingUtilities.getWindowAncestor(c);
            if (window instanceof Frame) {
                return (Frame)window;
            }
            if (window instanceof Dialog) {
                Dialog dialog = (Dialog)window;
                return WindowUtilities.getRootFrame(dialog.getOwner());
            }
        }
        return WindowUtilities.getPhonyFrame();
    }

    public static void initLookAndFeel() {
        WindowUtilities.initLookAndFeel("System");
    }

    public static void initLookAndFeel(String lafName) {
        WindowUtilities.initLookAndFeel(lafName, "Ocean");
    }

    public static void initLookAndFeel(String lafName, String lafTheme) {
        String lookAndFeel = null;
        if (lafName != null) {
            if (lafName.equals("Metal")) {
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            } else if (lafName.equals("System")) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
            } else if (lafName.equals("Motif")) {
                lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if (lafName.equals("GTK")) {
                lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else {
                Logger.getLogger(WindowUtilities.class.getName()).log(Level.SEVERE, "Unexpected value of LOOKANDFEEL specified: {0}", lafName);
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(lookAndFeel);
                if (lafName.equals("Metal")) {
                    if (lafTheme.equals("DefaultMetal")) {
                        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                    } else if (lafTheme.equals("Ocean")) {
                        MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                    }
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger(WindowUtilities.class.getName()).log(Level.SEVERE, "Couldn''t find class for specified look and feel:{0}\nDid you include the L&F library in the class path?\nUsing the default look and feel.", lookAndFeel);
            }
            catch (UnsupportedLookAndFeelException e) {
                Logger.getLogger(WindowUtilities.class.getName()).log(Level.SEVERE, "Can''t use the specified look and feel ({0}) on this platform.\nUsing the default look and feel.", lookAndFeel);
            }
            catch (Exception e) {
                Logger.getLogger(WindowUtilities.class.getName()).log(Level.SEVERE, "Couldn't get specified look and feel (" + lookAndFeel + "), for some reason." + "\n" + "Using the default look and feel.", e);
            }
        }
        Font textfieldFont = UIManager.getFont("TextField.font");
        UIManager.put("TextArea.font", new FontUIResource(textfieldFont));
        UIManager.put("TextPane.font", new FontUIResource(textfieldFont));
    }
}

