/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public abstract class JTwoButtonAbstractDialog
extends JDialog {
    private String text_ok;
    private String text_cancel;
    public static final String TEXT_OK = "     Ok     ";
    public static final String TEXT_CANCEL = " Anuleaza ";
    private static final String ACTION_OK = "ok";
    private static final String ACTION_CANCEL = "cancel";
    protected JPanel buttonsPane;
    protected JButton buttonOk;
    protected JButton buttonCancel;
    ActionListener buttonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (JTwoButtonAbstractDialog.ACTION_OK.equals(cmd)) {
                JTwoButtonAbstractDialog.this.shouldFireActionOk();
            } else if (JTwoButtonAbstractDialog.ACTION_CANCEL.equals(cmd)) {
                JTwoButtonAbstractDialog.this.shouldFireActionCancel();
            }
        }
    };
    WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            JTwoButtonAbstractDialog.this.shouldFireActionCancel();
        }
    };

    public JTwoButtonAbstractDialog(Frame owner, String title, boolean modal) {
        this(owner, title, modal, TEXT_OK, TEXT_CANCEL);
    }

    public JTwoButtonAbstractDialog(Frame owner, String title, boolean modal, String text_ok, String text_cancel) {
        super(owner, title, modal);
        this.text_ok = text_ok;
        this.text_cancel = text_cancel;
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.windowListener);
        this.buttonsPane = this.createButtonsPane();
        this.add((Component)this.buttonsPane, "South");
        this.initKeyBindings();
    }

    private JPanel createButtonsPane() {
        JPanel localPane = new JPanel();
        localPane.setLayout(new BoxLayout(localPane, 0));
        this.buttonOk = new JButton(this.text_ok);
        this.buttonOk.setActionCommand(ACTION_OK);
        this.buttonOk.addActionListener(this.buttonListener);
        this.buttonCancel = new JButton(this.text_cancel);
        this.buttonCancel.setActionCommand(ACTION_CANCEL);
        this.buttonCancel.addActionListener(this.buttonListener);
        localPane.add(Box.createHorizontalGlue());
        localPane.add(this.buttonOk);
        localPane.add(this.buttonCancel);
        localPane.add(Box.createHorizontalGlue());
        return localPane;
    }

    private void initKeyBindings() {
        JRootPane contentPane = this.getRootPane();
        ActionMap map = contentPane.getActionMap();
        AbstractAction actionOk = new AbstractAction(ACTION_OK){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTwoButtonAbstractDialog.this.shouldFireActionOk();
            }
        };
        map.put(actionOk.getValue("Name"), actionOk);
        AbstractAction actionCancel = new AbstractAction(ACTION_CANCEL){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTwoButtonAbstractDialog.this.shouldFireActionCancel();
            }
        };
        map.put(actionCancel.getValue("Name"), actionCancel);
        InputMap imap = contentPane.getInputMap(2);
        imap.put(KeyStroke.getKeyStroke("ENTER"), actionOk.getValue("Name"));
        imap.put(KeyStroke.getKeyStroke("ESCAPE"), actionCancel.getValue("Name"));
    }

    public void setProcentualSize(int procentWidth, int procentHeight) {
        this.setProcentualSize(new Dimension(procentWidth, procentHeight));
    }

    public void setProcentualSize(Dimension procentualDimension) {
        Dimension parentSize = this.getOwner().getSize();
        int newWidth = parentSize.width * procentualDimension.width / 100;
        int newHeight = parentSize.height * procentualDimension.height / 100;
        this.setSize(newWidth, newHeight);
    }

    public void setCenterComponent(Component comp) {
        this.add(comp, "Center");
    }

    public void setTopComponent(Component comp) {
        this.add(comp, "North");
    }

    public void setLeftComponent(Component comp) {
        this.add(comp, "West");
    }

    public void setRightComponent(Component comp) {
        this.add(comp, "East");
    }

    public void setTextOk(String text_ok) {
        this.text_ok = text_ok;
        this.buttonOk.setText(text_ok);
    }

    public void setTextCancel(String text_cancel) {
        this.text_cancel = text_cancel;
        this.buttonCancel.setText(text_cancel);
    }

    public void setEnableOk(boolean isEnabled) {
        this.buttonOk.setEnabled(isEnabled);
    }

    public void setEnableCancel(boolean isEnabled) {
        this.buttonCancel.setEnabled(isEnabled);
    }

    private void shouldFireActionOk() {
        if (this.buttonOk.isEnabled()) {
            this.fireActionOk();
        }
    }

    public abstract void fireActionOk();

    private void shouldFireActionCancel() {
        if (this.buttonCancel.isEnabled()) {
            this.fireActionCancel();
        }
    }

    public abstract void fireActionCancel();
}

