/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.propertiespanel.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import ro.genomeartist.components.propertiespanel.IEditorChangeListener;
import ro.genomeartist.components.propertiespanel.IPropertiesEditor;

public class JFileChooserPropertiesEditor
extends JPanel
implements IPropertiesEditor,
DocumentListener {
    private final Frame rootFrame;
    private JTextField textfield;
    private JButton selectButton;
    private JFileChooser fileChooser;
    private Vector<IEditorChangeListener> editorChangeListeners;

    public JFileChooserPropertiesEditor(Frame rootFrame, int columns) {
        this(rootFrame, columns, null);
    }

    public JFileChooserPropertiesEditor(Frame rootFrame, int columns, FileFilter fileFilter) {
        this.setLayout(new BorderLayout());
        this.rootFrame = rootFrame;
        this.textfield = new JTextField(columns);
        this.textfield.setEditable(false);
        this.selectButton = new JButton("..");
        this.add((Component)this.textfield, "Center");
        this.add((Component)this.selectButton, "East");
        this.fileChooser = new JFileChooser();
        if (fileFilter != null) {
            this.fileChooser.setFileFilter(fileFilter);
            this.fileChooser.setAcceptAllFileFilterUsed(false);
        }
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = JFileChooserPropertiesEditor.this.fileChooser.showOpenDialog(JFileChooserPropertiesEditor.this.rootFrame);
                if (returnVal == 0) {
                    File file = JFileChooserPropertiesEditor.this.fileChooser.getSelectedFile();
                    try {
                        BufferedImage imageFile = ImageIO.read(file);
                        JFileChooserPropertiesEditor.this.textfield.setText(file.getAbsolutePath());
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
        });
        this.editorChangeListeners = new Vector();
        this.textfield.getDocument().addDocumentListener(this);
    }

    @Override
    public JComponent getContainerComponent() {
        return this;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.textfield;
    }

    @Override
    public void setEditorName(String name) {
        this.setName(name);
        this.textfield.setName(name);
    }

    @Override
    public void setValue(Class objectClass, Object renderedObject) {
        if (File.class != objectClass) {
            throw new UnsupportedOperationException(objectClass + " not supported in JTextField");
        }
        File auxFile = (File)renderedObject;
        this.textfield.setText(auxFile.getPath());
        this.textfield.setHorizontalAlignment(2);
    }

    @Override
    public Object getValue(Class objectClass) {
        if (File.class == objectClass) {
            String auxString = this.textfield.getText();
            return new File(auxString);
        }
        throw new UnsupportedOperationException(objectClass + " not supported in JTextField");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textfield.setEnabled(enabled);
        this.selectButton.setEnabled(enabled);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    private void notifyAllListeners() {
        for (IEditorChangeListener iEditorChangeListener : this.editorChangeListeners) {
            iEditorChangeListener.fireValueChanged();
        }
    }

    @Override
    public void addEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.add(listener);
    }

    @Override
    public void removeEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.remove(listener);
    }
}

