/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.coloredtable.cellrenderers;

import exenne.components.coloredtable.AbstractColoredTableModel;
import exenne.components.coloredtable.JColoredTable;
import exenne.components.utils.GraphicRenderingUtils;
import exenne.components.utils.NumberUtils;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public abstract class AbstractColoredCellRenderer
extends DefaultTableCellRenderer {
    private JColoredTable coloredTable = null;
    private AbstractColoredTableModel coloredTableModel = null;
    private boolean isSelected = false;
    private boolean hasSomeFocus = false;
    private boolean isCellEditable = false;
    private boolean hasToolTipText = false;
    private Icon cellIcon = null;
    private Color prefferedBackground = null;
    private Color prefferedForeground = null;
    private int colorOffset = 15;

    public JColoredTable getColoredTable() {
        return this.coloredTable;
    }

    public AbstractColoredTableModel getColoredTableModel() {
        return this.coloredTableModel;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean hasSomeFocus() {
        return this.hasSomeFocus;
    }

    public boolean isCellEditable() {
        return this.isCellEditable;
    }

    public boolean hasToolTipText() {
        return this.hasToolTipText;
    }

    public Icon getCellIcon() {
        return this.cellIcon;
    }

    public Color getPrefferedBackground() {
        return this.prefferedBackground;
    }

    public Color getPrefferedForeground() {
        return this.prefferedForeground;
    }

    public int getColorOffset() {
        return this.colorOffset;
    }

    protected void setIsSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    protected void setHasSomeFocus(boolean hasSomeFocus) {
        this.hasSomeFocus = hasSomeFocus;
    }

    protected void setIsCellEditable(boolean isCellEditable) {
        this.isCellEditable = isCellEditable;
    }

    protected void setHasToolTipText(boolean hasToolTipText) {
        this.hasToolTipText = hasToolTipText;
    }

    protected void setCellIcon(Icon cellIcon) {
        this.cellIcon = cellIcon;
    }

    protected void setPrefferedBackground(Color prefferedBackground) {
        this.prefferedBackground = prefferedBackground;
    }

    protected void setPrefferedForeground(Color prefferedForeground) {
        this.prefferedForeground = prefferedForeground;
    }

    protected void setColorOffset(int colorOffset) {
        this.colorOffset = colorOffset;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color chosenForeground;
        Color chosenBackground;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.coloredTable = (JColoredTable)table;
        this.coloredTableModel = this.coloredTable.getModel();
        int modelrow = this.coloredTable.convertRowIndexToModel(row);
        int modelcolumn = this.coloredTable.convertColumnIndexToModel(column);
        this.isSelected = isSelected;
        this.hasSomeFocus = hasFocus;
        this.isCellEditable = this.coloredTableModel.isCellEditable(modelrow, modelcolumn);
        if (value instanceof String) {
            this.setText((String)value);
        } else if (value instanceof BigDecimal) {
            BigDecimal auxBigDecimal = (BigDecimal)value;
            this.setText(NumberUtils.formatBigDecimal(auxBigDecimal, this.coloredTableModel.getDecimalScale()));
        } else if (value instanceof Double) {
            Double auxDouble = (Double)value;
            this.setText(NumberUtils.formatDouble(auxDouble, this.coloredTableModel.getDecimalScale()));
        } else if (value instanceof Integer) {
            Integer auxInteger = (Integer)value;
            this.setText(NumberUtils.formatInteger(auxInteger));
        }
        this.setVerticalAlignment(1);
        if (value instanceof Number) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        String tooltipText = this.coloredTableModel.getTooltipText(modelrow, modelcolumn);
        this.setToolTipText(tooltipText);
        this.hasToolTipText = tooltipText != null;
        this.cellIcon = this.coloredTableModel.getCellIcon(modelrow, modelcolumn);
        this.setIcon(this.cellIcon);
        this.prefferedBackground = this.coloredTableModel.getBackground(modelrow, modelcolumn);
        this.prefferedForeground = this.coloredTableModel.getForeground(modelrow, modelcolumn);
        if (isSelected) {
            chosenBackground = table.getSelectionBackground();
            chosenForeground = table.getSelectionForeground();
        } else {
            chosenBackground = this.prefferedBackground;
            chosenForeground = this.prefferedForeground;
        }
        if (row % 2 == 0) {
            this.setBackground(GraphicRenderingUtils.lightenColor(chosenBackground, this.colorOffset));
        } else {
            this.setBackground(GraphicRenderingUtils.darkenColor(chosenBackground, this.colorOffset));
        }
        this.setForeground(chosenForeground);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("isSelected = ").append(this.isSelected).append('\n');
        stringBuilder.append("hasSomeFocus = ").append(this.hasSomeFocus).append('\n');
        stringBuilder.append("isCellEditable = ").append(this.isCellEditable).append('\n');
        stringBuilder.append("hasToolTipText = ").append(this.hasToolTipText).append('\n');
        stringBuilder.append("text = ").append(this.getText()).append('\n');
        stringBuilder.append("background = ").append(this.getBackground()).append('\n');
        stringBuilder.append("foreground = ").append(this.getForeground());
        stringBuilder.append('\n');
        stringBuilder.append("prefferedBackground = ").append(this.prefferedBackground);
        stringBuilder.append('\n');
        stringBuilder.append("prefferedForeground = ").append(this.prefferedForeground);
        stringBuilder.append('\n');
        stringBuilder.append("==========================");
        return stringBuilder.toString();
    }
}

