/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.coloredtable.test;

import exenne.components.coloredtable.AbstractColoredTableModel;
import exenne.components.coloredtable.JColoredTable;
import exenne.components.headerrenderer.JHeaderSorterIcons;
import exenne.components.headerrenderer.MultilineHeaderRenderer;
import exenne.components.jtable.viewportcontainer.JScrollableBottomSpacingContainer;
import exenne.components.utils.WindowUtilities;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class JColoredTableTestClass {
    private static void createAndShowGUI() {
        WindowUtilities.initLookAndFeel();
        JFrame frame = new JFrame("TableSelectionDemo");
        frame.setDefaultCloseOperation(3);
        AbstractColoredTableModel tableModel = new AbstractColoredTableModel(){

            public Color getBackground(int row, int col) {
                if (col > 0) {
                    return Color.RED;
                }
                return Color.CYAN;
            }

            public Color getForeground(int row, int col) {
                return null;
            }

            public int getRowCount() {
                return 30;
            }

            public int getColumnCount() {
                return 3;
            }

            public String getColumnName(int column) {
                if (column >= 0) {
                    return "column " + column;
                }
                return null;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                return "[" + rowIndex + "," + columnIndex + "]";
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return String.class;
                    }
                }
                assert (false);
                return null;
            }

            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 1: 
                    case 2: {
                        return true;
                    }
                }
                return false;
            }

            public String getTooltipText(int row, int col) {
                switch (col) {
                    case 0: 
                    case 1: {
                        return "test";
                    }
                }
                return null;
            }

            public Icon getCellIcon(int row, int col) {
                switch (col) {
                    case 1: {
                        return JHeaderSorterIcons.ASC.getIcon();
                    }
                }
                return null;
            }
        };
        JColoredTable coloredTable = new JColoredTable(tableModel);
        coloredTable.setRowHeight(coloredTable.getRowHeight());
        coloredTable.setFillsViewportHeight(true);
        TableRowSorter<1> tableSorter = new TableRowSorter<1>(tableModel);
        coloredTable.setRowSorter(tableSorter);
        tableSorter.toggleSortOrder(0);
        MultilineHeaderRenderer multirenderer = new MultilineHeaderRenderer();
        TableColumnModel columns = coloredTable.getColumnModel();
        TableColumn column = columns.getColumn(0);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(100);
        column = columns.getColumn(1);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(200);
        column = columns.getColumn(2);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(10);
        JScrollableBottomSpacingContainer containerPanel = new JScrollableBottomSpacingContainer(coloredTable);
        JScrollPane scrollPane = new JScrollPane(containerPanel);
        frame.add(scrollPane);
        frame.setSize(500, 500);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JColoredTableTestClass.createAndShowGUI();
            }
        });
    }
}

