/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.passwordfield.fixedwidth;

import exenne.components.popup.CopyPastePopupManager;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import javax.swing.JPasswordField;

public class JFixedWidthPasswordField
extends JPasswordField {
    public JFixedWidthPasswordField() {
        this(0);
    }

    public JFixedWidthPasswordField(int width) {
        this("", width);
    }

    public JFixedWidthPasswordField(String text, int width) {
        super(text);
        this.configureFixedWidth(width);
        this.setCopyPastePopupEnabled(true);
    }

    public void setFixedWidth(int width) {
        this.configureFixedWidth(width);
    }

    public void setCopyPastePopupEnabled(boolean shouldEnable) {
        MouseListener popupTrigger = CopyPastePopupManager.getCopyPastePopup().getPopupTrigger();
        this.removeMouseListener(popupTrigger);
        if (shouldEnable) {
            this.addMouseListener(popupTrigger);
        }
    }

    private void configureFixedWidth(int width) {
        if (width > 0) {
            int columnWidth = this.getColumnWidth();
            this.setColumns(width / columnWidth);
            this.setMaximumSize(new Dimension(width, width));
        }
    }
}

