/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.popup;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class JConfigurablePopup
extends JPopupMenu {
    public ActionListener myPopupListener = null;
    Hashtable<String, Component> items = new Hashtable();

    public JConfigurablePopup(ActionListener popupListener) {
        this.myPopupListener = popupListener;
    }

    public void addItem(String itemName) {
        this.addItem(itemName, null);
    }

    public void addItem(String itemName, Icon icon) {
        this.addItem(itemName, icon, -1, null);
    }

    public void addItem(String itemName, Icon icon, int mnemonic) {
        this.addItem(itemName, icon, mnemonic, null);
    }

    public void addItem(String itemName, String actionName, Icon icon, int mnemonic) {
        this.addItem(itemName, actionName, icon, mnemonic, null);
    }

    public void addItem(String itemName, Icon icon, KeyStroke accelerator) {
        this.addItem(itemName, icon, -1, accelerator);
    }

    public void addItem(String itemName, String actionName, Icon icon, KeyStroke accelerator) {
        this.addItem(itemName, actionName, icon, -1, accelerator);
    }

    public void addItem(String itemName, int mnemonic, KeyStroke accelerator) {
        this.addItem(itemName, null, mnemonic, accelerator);
    }

    public void addItem(String itemName, Icon icon, int mnemonic, KeyStroke accelerator) {
        this.addItem(itemName, itemName.toLowerCase(), icon, mnemonic, accelerator);
    }

    public void addItem(String itemName, String actionName, Icon icon, int mnemonic, KeyStroke accelerator) {
        JMenuItem menuItem = new JMenuItem(itemName);
        if (icon != null) {
            menuItem.setIcon(icon);
        }
        menuItem.setActionCommand(actionName);
        menuItem.addActionListener(this.myPopupListener);
        if (mnemonic >= 0) {
            menuItem.setMnemonic(mnemonic);
        }
        if (accelerator != null) {
            menuItem.setAccelerator(accelerator);
        }
        this.items.put(itemName, menuItem);
        this.add(menuItem);
    }

    public void removeItem(String itemName) {
        Component menuItem = this.items.get(itemName);
        this.remove(menuItem);
        this.items.remove(itemName);
    }

    public void addMenu(JMenu menu) {
        this.items.put(menu.getName(), menu);
        this.add(menu);
    }

    public void addNamedSeparator(String itemName) {
        int componentCount = this.getComponentCount();
        this.addSeparator();
        this.items.put(itemName, this.getComponent(componentCount));
    }

    public void setItemEnabled(String itemName) {
        Component menuItem = this.items.get(itemName);
        if (menuItem != null) {
            menuItem.setEnabled(true);
        }
    }

    public void setItemDisabled(String itemName) {
        Component menuItem = this.items.get(itemName);
        if (menuItem != null) {
            menuItem.setEnabled(false);
        }
    }

    public void setItemVisible(String itemName) {
        Component menuItem = this.items.get(itemName);
        if (menuItem != null) {
            menuItem.setVisible(true);
        }
    }

    public void setItemInvisible(String itemName) {
        Component menuItem = this.items.get(itemName);
        if (menuItem != null) {
            menuItem.setVisible(false);
        }
    }
}

