/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.propertiespanel;

import exenne.components.jdatepicker.util.JDatePickerUtil;
import exenne.components.propertiespanel.AbstractPropertiesPanelModel;
import exenne.components.propertiespanel.IPropertiesEditor;
import exenne.components.propertiespanel.IPropertiesHeader;
import exenne.components.propertiespanel.IValidationProblemListener;
import exenne.components.propertiespanel.JPropertiesPanel;
import exenne.components.propertiespanel.editors.JCheckBoxPropertiesEditor;
import exenne.components.propertiespanel.editors.JColorChooserPropertiesEditor;
import exenne.components.propertiespanel.editors.JComboBoxPropertiesEditor;
import exenne.components.propertiespanel.editors.JDatePickerPropertiesEditor;
import exenne.components.propertiespanel.editors.JFileChooserPropertiesEditor;
import exenne.components.propertiespanel.editors.JImageChooserPropertiesEditor;
import exenne.components.propertiespanel.editors.JTextAreaPropertiesEditor;
import exenne.components.propertiespanel.editors.JTextFieldPropertiesEditor;
import exenne.components.propertiespanel.headers.JLabelPropertiesHeader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.DateDayRange;
import org.netbeans.validation.api.builtin.Validators;

public class TestWindow
extends JFrame {
    private static final String LOOKANDFEEL = "System";
    private static final String THEME = "Ocean";
    private JPropertiesPanel propertiesPanel;
    private JButton commitButton;
    private AbstractPropertiesPanelModel panelModel = new AbstractPropertiesPanelModel(){
        private static final int FIELD_ROWS = 3;
        private static final int FIELD_WIDTH = 150;
        private static final int LABEL_WIDTH = 150;
        public static final int ROW_0 = 0;
        public static final int ROW_1 = 1;
        public static final int ROW_2 = 2;
        public static final int ROW_3 = 3;
        public static final int ROW_4 = 4;
        public static final int ROW_5 = 5;
        public static final int ROW_6 = 6;
        public static final int ROW_7 = 7;
        public static final int ROW_8 = 8;
        public static final int ROW_9 = 9;
        public static final int ROW_10 = 10;
        private String textfieldString = "test value";
        private Integer textfieldInteger = 21;
        private BigDecimal textfieldBigDecimal = new BigDecimal("232.123");
        private String textareaString = "ole ole \n newline \n ole";
        private Date datePickerDate = new Date(111, 0, 1);
        private String comboString = "cal";
        private String[] comboValues = new String[]{"pisica", "cal", "magar", "urs"};
        private Boolean checkboxBoolean = false;
        private Boolean checkboxBooleanSecond = false;
        private Color colorChooserColor = Color.blue;
        private File fileChooserFile = new File("/home/iulian");
        private BufferedImage bufferedImage = new BufferedImage(100, 100, 6);

        public int getRowCount() {
            return 11;
        }

        public int getLabelWidth() {
            return 150;
        }

        public Class getClassAt(int row) {
            switch (row) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return BigDecimal.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return Date.class;
                }
                case 5: {
                    return String.class;
                }
                case 6: {
                    return Boolean.class;
                }
                case 7: {
                    return Boolean.class;
                }
                case 8: {
                    return Color.class;
                }
                case 9: {
                    return File.class;
                }
                case 10: {
                    return BufferedImage.class;
                }
            }
            assert (false);
            return null;
        }

        public String getDescriptionAt(int row) {
            switch (row) {
                case 0: {
                    return "textfield String";
                }
                case 1: {
                    return "textfield Integer";
                }
                case 2: {
                    return "textfield BigDecimal";
                }
                case 3: {
                    return "textarea String";
                }
                case 4: {
                    return "datePicker Date";
                }
                case 5: {
                    return "combo String";
                }
                case 6: {
                    return null;
                }
                case 7: {
                    return null;
                }
                case 8: {
                    return "colorChooser Color";
                }
                case 9: {
                    return "fileChooser File";
                }
                case 10: {
                    return "imageChoose BufferedImage";
                }
            }
            assert (false);
            return null;
        }

        public IPropertiesEditor createEditorComponentAt(int row) {
            switch (row) {
                case 0: {
                    return new JTextFieldPropertiesEditor(150);
                }
                case 1: {
                    return new JTextFieldPropertiesEditor(150, "%");
                }
                case 2: {
                    return new JTextFieldPropertiesEditor(150);
                }
                case 3: {
                    return new JTextAreaPropertiesEditor(3, 150);
                }
                case 4: {
                    return new JDatePickerPropertiesEditor();
                }
                case 5: {
                    return new JComboBoxPropertiesEditor(new JComboBox<String>(this.comboValues));
                }
                case 6: {
                    return new JCheckBoxPropertiesEditor("Test1");
                }
                case 7: {
                    return new JCheckBoxPropertiesEditor("Test2");
                }
                case 8: {
                    return new JColorChooserPropertiesEditor();
                }
                case 9: {
                    return new JFileChooserPropertiesEditor(TestWindow.this, 150);
                }
                case 10: {
                    return new JImageChooserPropertiesEditor(TestWindow.this, 150, 165, 60);
                }
            }
            assert (false);
            return null;
        }

        public IPropertiesHeader createHeaderComponentAt(int row) {
            switch (row) {
                case 0: {
                    return new JLabelPropertiesHeader("header1");
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return null;
                }
                case 3: {
                    return null;
                }
                case 4: {
                    return null;
                }
                case 5: {
                    return new JLabelPropertiesHeader("header2");
                }
                case 6: {
                    return null;
                }
                case 7: {
                    return null;
                }
                case 8: {
                    return null;
                }
                case 9: {
                    return null;
                }
                case 10: {
                    return null;
                }
            }
            assert (false);
            return null;
        }

        public void fireActionRowChanged(int row) {
            switch (row) {
                case 1: {
                    IPropertiesEditor myEditor = this.getEditorComponentAt(1);
                    IPropertiesEditor hisEditor = this.getEditorComponentAt(2);
                    Integer integer = (Integer)myEditor.getValue(Integer.class);
                    BigDecimal bigDecimal = new BigDecimal(integer);
                    bigDecimal = bigDecimal.add(BigDecimal.ONE);
                    if (bigDecimal.compareTo(BigDecimal.TEN) <= 0) break;
                    hisEditor.setValue(BigDecimal.class, bigDecimal);
                    break;
                }
            }
        }

        public boolean isRowOnNewline(int row) {
            switch (row) {
                case 7: {
                    return false;
                }
            }
            return true;
        }

        public Validator getValidatorAt(int row) {
            switch (row) {
                case 0: {
                    return Validators.forDocument(false, Validators.REQUIRE_NON_EMPTY_STRING);
                }
                case 1: {
                    return Validators.forDocument(false, Validators.REQUIRE_NON_EMPTY_STRING, Validators.REQUIRE_VALID_INTEGER, Validators.REQUIRE_NON_NEGATIVE_NUMBER);
                }
                case 2: {
                    return Validators.forDocument(false, Validators.REQUIRE_NON_EMPTY_STRING, Validators.REQUIRE_VALID_NUMBER, Validators.REQUIRE_NON_NEGATIVE_NUMBER);
                }
                case 3: {
                    return Validators.forDocument(false, Validators.REQUIRE_NON_EMPTY_STRING);
                }
                case 4: {
                    return Validators.forDocument(false, Validators.REQUIRE_NON_EMPTY_STRING, new DateDayRange(JDatePickerUtil.getMediumDateFormat(), this.datePickerDate, null, false));
                }
                case 9: {
                    return Validators.forDocument(false, Validators.REQUIRE_NON_EMPTY_STRING, Validators.FILE_MUST_EXIST);
                }
            }
            return null;
        }

        public int getRowHeightAt(int row) {
            switch (row) {
                case 3: {
                    return 100;
                }
            }
            return 0;
        }

        public Object getValueAt(int row) {
            switch (row) {
                case 0: {
                    return this.textfieldString;
                }
                case 1: {
                    return this.textfieldInteger;
                }
                case 2: {
                    return this.textfieldBigDecimal;
                }
                case 3: {
                    return this.textareaString;
                }
                case 4: {
                    return this.datePickerDate;
                }
                case 5: {
                    return this.comboString;
                }
                case 6: {
                    return this.checkboxBoolean;
                }
                case 7: {
                    return this.checkboxBooleanSecond;
                }
                case 8: {
                    return this.colorChooserColor;
                }
                case 9: {
                    return this.fileChooserFile;
                }
                case 10: {
                    return this.bufferedImage;
                }
            }
            assert (false);
            return null;
        }

        public boolean setValueAt(int row, Object newValue) {
            System.out.println(row + "->" + newValue);
            if (this.getValueAt(row).equals(newValue)) {
                return false;
            }
            switch (row) {
                case 0: {
                    String auxString;
                    this.textfieldString = auxString = (String)newValue;
                    return true;
                }
                case 1: {
                    Integer auxInteger;
                    this.textfieldInteger = auxInteger = (Integer)newValue;
                    return true;
                }
                case 2: {
                    BigDecimal auxBigDecimal;
                    this.textfieldBigDecimal = auxBigDecimal = (BigDecimal)newValue;
                    return true;
                }
                case 3: {
                    String auxString;
                    this.textareaString = auxString = (String)newValue;
                    return true;
                }
                case 4: {
                    Date auxDate;
                    this.datePickerDate = auxDate = (Date)newValue;
                    return true;
                }
                case 5: {
                    String auxString;
                    this.comboString = auxString = (String)newValue;
                    return true;
                }
                case 6: {
                    Boolean auxBoolean;
                    this.checkboxBoolean = auxBoolean = (Boolean)newValue;
                    return true;
                }
                case 7: {
                    Boolean auxBoolean;
                    this.checkboxBooleanSecond = auxBoolean = (Boolean)newValue;
                    return true;
                }
                case 8: {
                    Color auxColor;
                    this.colorChooserColor = auxColor = (Color)newValue;
                    return true;
                }
                case 9: {
                    File auxFile;
                    this.fileChooserFile = auxFile = (File)newValue;
                    return true;
                }
                case 10: {
                    BufferedImage auxBufferedImage;
                    this.bufferedImage = auxBufferedImage = (BufferedImage)newValue;
                    return true;
                }
            }
            return false;
        }
    };

    public TestWindow() {
        TestWindow.initLookAndFeel();
        this.setSize(600, 500);
        this.setLocation(150, 0);
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.propertiesPanel = new JPropertiesPanel(this.panelModel);
        this.propertiesPanel.addValidationProblemListener(new IValidationProblemListener(){

            public void validationProblemChanged(Problem problem) {
                boolean enable = problem == null ? true : problem.severity() != Severity.FATAL;
                TestWindow.this.commitButton.setEnabled(enable);
                TestWindow.this.setDefaultCloseOperation(!enable ? 0 : 3);
            }
        });
        this.add((Component)this.propertiesPanel, "Center");
        this.commitButton = new JButton("Commit");
        this.commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean hasChanged = TestWindow.this.propertiesPanel.commitChanges();
                System.out.println("hasChanged = " + hasChanged);
            }
        });
        this.add((Component)this.commitButton, "South");
        this.pack();
    }

    public static void initLookAndFeel() {
        String lookAndFeel = null;
        if (LOOKANDFEEL != null) {
            if (LOOKANDFEEL.equals("Metal")) {
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals(LOOKANDFEEL)) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals("Motif")) {
                lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if (LOOKANDFEEL.equals("GTK")) {
                lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else {
                System.err.println("Unexpected value of LOOKANDFEEL specified: System");
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(lookAndFeel);
                if (LOOKANDFEEL.equals("Metal")) {
                    if (THEME.equals("DefaultMetal")) {
                        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                    } else if (THEME.equals(THEME)) {
                        MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                    }
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("Couldn't find class for specified look and feel:" + lookAndFeel);
                System.err.println("Did you include the L&F library in the class path?");
                System.err.println("Using the default look and feel.");
            }
            catch (UnsupportedLookAndFeelException e) {
                System.err.println("Can't use the specified look and feel (" + lookAndFeel + ") on this platform.");
                System.err.println("Using the default look and feel.");
            }
            catch (Exception e) {
                System.err.println("Couldn't get specified look and feel (" + lookAndFeel + "), for some reason.");
                System.err.println("Using the default look and feel.");
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        Locale.setDefault(new Locale("ro", "RO"));
        TestWindow testWindow = new TestWindow();
        testWindow.setVisible(true);
    }
}

