/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.propertiespanel.editors;

import exenne.components.propertiespanel.IEditorChangeListener;
import exenne.components.propertiespanel.IPropertiesEditor;
import exenne.components.textarea.fixedwidth.JFixedWidthTextArea;
import exenne.components.utils.StringUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JTextAreaPropertiesEditor
extends JScrollPane
implements IPropertiesEditor,
DocumentListener {
    private JTextArea textarea;
    private Vector<IEditorChangeListener> editorChangeListeners;

    public JTextAreaPropertiesEditor(int rows, int cols) {
        super(20, 31);
        this.textarea = new JFixedWidthTextArea(rows, cols);
        this.initialize();
    }

    public JTextAreaPropertiesEditor() {
        super(20, 31);
        this.textarea = new JFixedWidthTextArea();
        this.initialize();
    }

    private void initialize() {
        this.setViewportView(this.textarea);
        this.textarea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JTextAreaPropertiesEditor.this.textarea.selectAll();
            }
        });
        this.editorChangeListeners = new Vector();
        this.textarea.getDocument().addDocumentListener(this);
        this.registerLocalKeyBindings();
    }

    private void registerLocalKeyBindings() {
        ActionMap map = this.textarea.getActionMap();
        AbstractAction actionReleaseFocus = new AbstractAction("release focus"){

            public void actionPerformed(ActionEvent evt) {
                ((Component)evt.getSource()).transferFocus();
            }
        };
        map.put(actionReleaseFocus.getValue("Name"), actionReleaseFocus);
        InputMap imap = this.textarea.getInputMap(0);
        imap.put(KeyStroke.getKeyStroke("TAB"), actionReleaseFocus.getValue("Name"));
    }

    public JComponent getContainerComponent() {
        return this;
    }

    public JComponent getEditorComponent() {
        return this.textarea;
    }

    public void setEditorName(String name) {
        this.textarea.setName(name);
    }

    public void setValue(Class objectClass, Object renderedObject) {
        if (String.class != objectClass) {
            throw new UnsupportedOperationException(objectClass + " not supported in JTextArea");
        }
        String auxString = (String)renderedObject;
        this.textarea.setText(auxString);
    }

    public Object getValue(Class objectClass) {
        if (String.class == objectClass) {
            String auxString = StringUtilities.removeWindowsCarriageReturn(this.textarea.getText());
            return auxString;
        }
        throw new UnsupportedOperationException(objectClass + " not supported in JTextArea");
    }

    public void insertUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    public void removeUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    public void changedUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    private void notifyAllListeners() {
        for (IEditorChangeListener iEditorChangeListener : this.editorChangeListeners) {
            iEditorChangeListener.fireValueChanged();
        }
    }

    public void addEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.add(listener);
    }

    public void removeEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.remove(listener);
    }
}

