/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.swingworkers.progressworker;

import exenne.components.dialogs.DialogFactory;
import exenne.components.modalpanel.progresspanel.JModalProgressPanel;
import exenne.components.swingworkers.IWorker;
import exenne.components.swingworkers.progressworker.AbstractProgressCallable;
import exenne.components.swingworkers.progressworker.ProgressInfoManager;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JProgressSwingWorker<T>
extends SwingWorker<T, String>
implements IWorker,
ProgressInfoManager,
PropertyChangeListener {
    private final Frame rootFrame;
    protected JModalProgressPanel progressPanel;
    private boolean hasFinished;
    private boolean isPanelVisible;
    private int delay;
    private ResourceBundle resourceBundle = null;
    private static final int DEFAULT_DELAY_STEP = 100;
    private static int DEFAULT_DELAY = 500;
    protected AbstractProgressCallable<T> callableMethod;
    protected T result;
    private Vector<String> errorVector;
    private String standardError = null;

    public JProgressSwingWorker(Frame rootFrame, AbstractProgressCallable<T> callableMethod) {
        this(rootFrame, "", callableMethod);
    }

    public JProgressSwingWorker(Frame rootFrame, AbstractProgressCallable<T> callableMethod, int mode) {
        this(rootFrame, "", callableMethod, mode);
    }

    public JProgressSwingWorker(Frame rootFrame, String description, AbstractProgressCallable<T> callableMethod) {
        this(rootFrame, description, callableMethod, DEFAULT_DELAY, 0);
    }

    public JProgressSwingWorker(Frame rootFrame, String description, AbstractProgressCallable<T> callableMethod, int mode) {
        this(rootFrame, description, callableMethod, DEFAULT_DELAY, mode);
    }

    public JProgressSwingWorker(Frame rootFrame, String description, AbstractProgressCallable<T> callableMethod, int delay, int mode) {
        this.rootFrame = rootFrame;
        this.resourceBundle = ResourceBundle.getBundle("exenne/components/swingworkers/progressworker/messages", rootFrame.getLocale());
        this.progressPanel = new JModalProgressPanel(rootFrame);
        this.callableMethod = callableMethod;
        callableMethod.setProgressInfoManager(this);
        this.addPropertyChangeListener(this);
        this.delay = delay;
        this.progressPanel.setDisplayMode(description, mode);
        this.errorVector = new Vector();
    }

    public void setDescription(String description) {
        this.progressPanel.setDisplayMode(description, 0);
    }

    public void setStandardErrorMessage(String errorMessage) {
        this.standardError = errorMessage;
    }

    public T executeTask() {
        this.execute();
        int steps = this.delay / 100;
        this.hasFinished = false;
        for (int i = 0; i < steps; ++i) {
            if (this.getState() == SwingWorker.StateValue.DONE) {
                this.hasFinished = true;
                break;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.isPanelVisible = false;
        boolean bl = this.hasFinished = this.getState() == SwingWorker.StateValue.DONE;
        if (!this.hasFinished) {
            this.isPanelVisible = true;
            this.progressPanel.setVisible(true);
        }
        try {
            this.result = this.get();
        }
        catch (Exception ex) {
            this.result = null;
            Logger.getLogger(JProgressSwingWorker.class.getName()).log(Level.WARNING, "Exceptie la rulare Worker", ex);
            StringBuilder error = new StringBuilder();
            if (this.standardError != null) {
                error.append(this.standardError);
            } else {
                error.append(ex.getMessage());
            }
            if (!this.errorVector.isEmpty()) {
                error.append("\n").append(this.resourceBundle.getString("error.cause")).append("\n");
            }
            for (int i = 0; i < this.errorVector.size(); ++i) {
                String stringItem = this.errorVector.elementAt(i);
                error.append(i + 1).append(". ").append(stringItem).append("\n");
            }
            DialogFactory.showErrorDialog(this.rootFrame, this.resourceBundle.getString("error.title"), error.toString());
        }
        return this.result;
    }

    @Override
    protected T doInBackground() throws Exception {
        return (T)this.callableMethod.call();
    }

    @Override
    public void setProgressValue(int value) {
        this.setProgress(value);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            int progress = (Integer)evt.getNewValue();
            this.progressPanel.setProgress(progress);
        }
    }

    @Override
    public void setProgressInfo(String info) {
        this.publish(info);
    }

    @Override
    public void addErrorMessage(String message) {
        this.errorVector.add(message);
    }

    @Override
    protected void process(List<String> chunks) {
        String info = chunks.get(chunks.size() - 1);
        this.progressPanel.setText(info);
    }

    @Override
    protected void done() {
        this.hasFinished = true;
        this.closeProgressPanel();
    }

    private void closeProgressPanel() {
        if (this.isPanelVisible) {
            this.progressPanel.setVisible(false);
            this.progressPanel.dispose();
            this.isPanelVisible = false;
        }
    }
}

