/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.tree.traversal;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafNodeTraversal
implements Enumeration<DefaultMutableTreeNode> {
    private DefaultMutableTreeNode targetNode;
    private DefaultMutableTreeNode currentNode;
    private DefaultMutableTreeNode nextNode;

    public LeafNodeTraversal(DefaultMutableTreeNode targetNode) {
        this.targetNode = targetNode;
        this.currentNode = null;
        this.nextNode = targetNode.isLeaf() ? targetNode : this.computeNextElement(targetNode);
    }

    private DefaultMutableTreeNode getNextSubsrootedSibling(DefaultMutableTreeNode currentNode) {
        if (currentNode == null || currentNode != null && currentNode.equals(this.targetNode)) {
            return null;
        }
        DefaultMutableTreeNode nextSibling = currentNode.getNextSibling();
        if (nextSibling != null) {
            return nextSibling;
        }
        return this.getNextSubsrootedSibling((DefaultMutableTreeNode)currentNode.getParent());
    }

    private DefaultMutableTreeNode computeNextElement(DefaultMutableTreeNode currentNode) {
        if (currentNode.getChildCount() != 0) {
            return currentNode.getFirstLeaf();
        }
        DefaultMutableTreeNode nextRootSibling = this.getNextSubsrootedSibling(currentNode);
        if (nextRootSibling != null) {
            return nextRootSibling.getFirstLeaf();
        }
        return null;
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextNode != null;
    }

    @Override
    public DefaultMutableTreeNode nextElement() {
        if (this.hasMoreElements()) {
            this.currentNode = this.nextNode;
            this.nextNode = this.computeNextElement(this.currentNode);
            return this.currentNode;
        }
        throw new NoSuchElementException("No more nodes");
    }

    public static void main(String[] args) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("rootNode");
        DefaultMutableTreeNode child1 = new DefaultMutableTreeNode("child1");
        DefaultMutableTreeNode child1_1 = new DefaultMutableTreeNode("child1_1");
        DefaultMutableTreeNode child1_2 = new DefaultMutableTreeNode("child1_2");
        DefaultMutableTreeNode child1_3 = new DefaultMutableTreeNode("child1_3");
        DefaultMutableTreeNode child2 = new DefaultMutableTreeNode("child2");
        DefaultMutableTreeNode child2_1 = new DefaultMutableTreeNode("child2_1");
        DefaultMutableTreeNode child3 = new DefaultMutableTreeNode("child3");
        DefaultMutableTreeNode child3_1 = new DefaultMutableTreeNode("child3_1");
        DefaultMutableTreeNode child3_2 = new DefaultMutableTreeNode("child3_2");
        rootNode.add(child1);
        child1.add(child1_1);
        child1.add(child1_2);
        child1.add(child1_3);
        rootNode.add(child2);
        child2.add(child2_1);
        rootNode.add(child3);
        child3.add(child3_1);
        child3.add(child3_2);
        LeafNodeTraversal nodeTraversal = new LeafNodeTraversal(child1);
        while (nodeTraversal.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)nodeTraversal.nextElement();
            String item = (String)defaultMutableTreeNode.getUserObject();
            System.out.println(item);
        }
    }
}

