/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable;

import exenne.components.treetable.EventBroadcaster;
import exenne.components.treetable.NodeRowModel;
import exenne.components.treetable.ProxyTableModel;
import exenne.components.treetable.RowModel;
import exenne.components.treetable.TreePathSupport;
import exenne.components.treetable.TreetableModel;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.VariableHeightLayoutCache;

public class DefaultTreetableModel
implements TreetableModel {
    private TreeModel treeModel;
    private ProxyTableModel tableModel;
    private RowModel rowModel;
    private AbstractLayoutCache layout;
    private TreePathSupport treePathSupport;
    private EventBroadcaster broadcaster;
    private static final int NODES_CHANGED = 0;
    private static final int NODES_INSERTED = 1;
    private static final int NODES_REMOVED = 2;
    private static final int STRUCTURE_CHANGED = 3;
    private String nodeColumnName;
    private static final String[] types = new String[]{"nodesChanged", "nodesInserted", "nodesRemoved", "structureChanged"};

    public static TreetableModel createOutlineModel(RowModel rowModel) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultTreeModel treeMdl = new DefaultTreeModel(root, false);
        ProxyTableModel proxyTableModel = new ProxyTableModel(rowModel);
        return new DefaultTreetableModel(treeMdl, proxyTableModel, true);
    }

    public static TreetableModel createOutlineModel(RowModel rowModel, TreeModel treeMdl) {
        ProxyTableModel proxyTableModel = new ProxyTableModel(rowModel);
        return new DefaultTreetableModel(treeMdl, proxyTableModel, true);
    }

    protected DefaultTreetableModel(TreeModel treeModel, ProxyTableModel tableModel, boolean largeModel) {
        this.treeModel = treeModel;
        this.tableModel = tableModel;
        this.rowModel = tableModel.getRowModel();
        this.layout = largeModel ? new FixedHeightLayoutCache() : new VariableHeightLayoutCache();
        this.broadcaster = new EventBroadcaster(this);
        this.layout.setRootVisible(true);
        this.layout.setModel(this);
        this.treePathSupport = new TreePathSupport(this, this.layout);
        this.treePathSupport.addTreeExpansionListener(this.broadcaster);
        this.treePathSupport.addTreeWillExpandListener(this.broadcaster);
        treeModel.addTreeModelListener(this.broadcaster);
        tableModel.addTableModelListener(this.broadcaster);
        if (tableModel instanceof ProxyTableModel) {
            tableModel.setOutlineModel(this);
        }
    }

    public final TreePathSupport getTreePathSupport() {
        return this.treePathSupport;
    }

    public final void setTreePathSupport(TreePathSupport treePathSupport) {
        this.treePathSupport = treePathSupport;
    }

    public final AbstractLayoutCache getLayout() {
        return this.layout;
    }

    public boolean isLargeModel() {
        return this.layout instanceof FixedHeightLayoutCache;
    }

    public void setNodeColumnName(String inName) {
        this.nodeColumnName = inName;
    }

    public NodeRowModel getRowNodeModel() {
        return this.tableModel;
    }

    public RowModel getRowModel() {
        return this.rowModel;
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(TreeModel treeModel) {
        this.treeModel = treeModel;
        treeModel.addTreeModelListener(this.broadcaster);
    }

    public EventBroadcaster getBroadcaster() {
        return this.broadcaster;
    }

    public void registerBroadcaster(EventBroadcaster newBroadcaster) {
        this.treePathSupport.addTreeExpansionListener(newBroadcaster);
        this.treePathSupport.addTreeWillExpandListener(newBroadcaster);
    }

    public void registerExpansionListener(TreeExpansionListener expansionListener) {
        this.treePathSupport.addTreeExpansionListener(expansionListener);
        this.treePathSupport.addTreeWillExpandListener(expansionListener);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public final Object getRoot() {
        return this.treeModel.getRoot();
    }

    public final Object getChild(Object parent, int index) {
        return this.treeModel.getChild(parent, index);
    }

    public final int getChildCount(Object parent) {
        return this.treeModel.getChildCount(parent);
    }

    public final boolean isLeaf(Object node) {
        if (null == node) {
            return true;
        }
        return this.treeModel.isLeaf(node);
    }

    public final void valueForPathChanged(TreePath path, Object newValue) {
        this.treeModel.valueForPathChanged(path, newValue);
    }

    public final int getIndexOfChild(Object parent, Object child) {
        return this.treeModel.getIndexOfChild(parent, child);
    }

    public final synchronized void addTreeModelListener(TreeModelListener l) {
        this.broadcaster.addTreeModelListener(l);
    }

    public final synchronized void removeTreeModelListener(TreeModelListener l) {
        this.broadcaster.removeTreeModelListener(l);
    }

    public final int getRowCount() {
        return this.layout.getRowCount();
    }

    public final int getColumnCount() {
        return this.tableModel.getColumnCount() + 1;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return null == this.nodeColumnName ? "Nodes" : this.nodeColumnName;
        }
        return this.tableModel.getColumnName(columnIndex - 1);
    }

    public final Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Object.class;
        }
        return this.tableModel.getColumnClass(columnIndex - 1);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        return this.tableModel.isCellEditable(rowIndex, columnIndex - 1);
    }

    public final Object getValueAt(int rowIndex, int columnIndex) {
        TreePath path;
        Object result = columnIndex == 0 ? ((path = this.getLayout().getPathForRow(rowIndex)) != null ? path.getLastPathComponent() : null) : this.tableModel.getValueAt(rowIndex, columnIndex - 1);
        return result;
    }

    public final void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            this.tableModel.setValueAt(aValue, rowIndex, columnIndex - 1);
        }
    }

    public final synchronized void addTableModelListener(TableModelListener l) {
        this.broadcaster.addTableModelListener(l);
    }

    public final synchronized void removeTableModelListener(TableModelListener l) {
        this.broadcaster.removeTableModelListener(l);
    }
}

