/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable;

import exenne.components.treetable.Treetable;
import exenne.components.treetable.TreetableSelectionListener;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreetableListSelectionHandler
implements ListSelectionListener {
    private Treetable outline;
    Stack<Integer> selectionMarkers;
    Vector<TreetableSelectionListener> selectionListeners;

    public TreetableListSelectionHandler(Treetable outline) {
        this.outline = outline;
        this.selectionMarkers = new Stack();
        this.selectionListeners = new Vector();
    }

    public void addSelectionListener(TreetableSelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(TreetableSelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    private void notifyListeners() {
        for (TreetableSelectionListener listener : this.selectionListeners) {
            listener.selectionChanged();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        AbstractLayoutCache layout;
        int[] sels = null;
        boolean en = this.outline.getSelectedRow() != -1;
        ListSelectionModel m = this.outline.getSelectionModel();
        boolean bl = en = this.outline.getSelectedNode() != null;
        if (en) {
            DefaultMutableTreeNode nd = this.outline.getSelectedNode();
            en = nd.getChildCount() > 1;
        }
        boolean bl2 = en = this.outline.getSelectedNode() != null;
        if (en) {
            sels = this.outline.getSelectedIndices();
            boolean bl3 = en = sels.length > 1;
            if (sels.length > this.outline.getRowCount()) {
                en = false;
            }
            if (en) {
                DefaultMutableTreeNode lastParent = null;
                for (int i = 0; i < sels.length; ++i) {
                    DefaultMutableTreeNode nd = (DefaultMutableTreeNode)this.outline.getValueAt(sels[i], 0);
                    if (nd == null) {
                        en = false;
                        break;
                    }
                    if (lastParent != null) {
                        if (en &= nd.getParent() == lastParent) continue;
                        break;
                    }
                    lastParent = (DefaultMutableTreeNode)nd.getParent();
                }
            }
        }
        while (!this.selectionMarkers.empty()) {
            Integer prevoiusRow = this.selectionMarkers.pop();
            this.outline.repaintRow(prevoiusRow);
            layout = this.outline.getLayoutCache();
            TreePath path = layout.getPathForRow(prevoiusRow);
            int visibleChildCount = layout.getVisibleChildCount(path);
            for (int j = 0; j < visibleChildCount; ++j) {
                int row_index = prevoiusRow + j + 1;
                this.outline.repaintRow(row_index);
            }
        }
        layout = this.outline.getLayoutCache();
        if (sels != null) {
            for (int i = 0; i < sels.length; ++i) {
                this.selectionMarkers.add(sels[i]);
                TreePath path = layout.getPathForRow(sels[i]);
                int visibleChildCount = layout.getVisibleChildCount(path);
                for (int j = 0; j < visibleChildCount; ++j) {
                    int row_index = sels[i] + j + 1;
                    this.outline.repaintRow(row_index);
                }
            }
        }
        this.notifyListeners();
    }

    public void reset() {
        this.selectionMarkers.empty();
    }

    private int getVisibleChildCount(DefaultMutableTreeNode node) {
        boolean visibleChilds = false;
        AbstractLayoutCache layout = this.outline.getLayoutCache();
        return 0;
    }
}

