/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.undosystem.tutorial;

import exenne.components.undosystem.tutorial.BasicWindowMonitor;
import exenne.components.undosystem.tutorial.UndoableToggleEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class UndoableToggleApp
extends JFrame
implements ActionListener {
    private UndoableEdit edit;
    private JButton undoButton;
    private JButton redoButton;

    public UndoableToggleApp() {
        JToggleButton tog = new JToggleButton("ToggleButton");
        JCheckBox cb = new JCheckBox("CheckBox");
        JRadioButton radio = new JRadioButton("RadioButton");
        tog.addActionListener(this);
        cb.addActionListener(this);
        radio.addActionListener(this);
        Box buttonBox = new Box(1);
        buttonBox.add(tog);
        buttonBox.add(cb);
        buttonBox.add(radio);
        this.undoButton = new JButton("Undo");
        this.redoButton = new JButton("Redo");
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        this.undoButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    UndoableToggleApp.this.edit.undo();
                }
                catch (CannotUndoException ex) {
                    ex.printStackTrace();
                }
                finally {
                    UndoableToggleApp.this.undoButton.setEnabled(UndoableToggleApp.this.edit.canUndo());
                    UndoableToggleApp.this.redoButton.setEnabled(UndoableToggleApp.this.edit.canRedo());
                }
            }
        });
        this.redoButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    UndoableToggleApp.this.edit.redo();
                }
                catch (CannotRedoException ex) {
                    ex.printStackTrace();
                }
                finally {
                    UndoableToggleApp.this.undoButton.setEnabled(UndoableToggleApp.this.edit.canUndo());
                    UndoableToggleApp.this.redoButton.setEnabled(UndoableToggleApp.this.edit.canRedo());
                }
            }
        });
        Box undoRedoBox = new Box(0);
        undoRedoBox.add(Box.createGlue());
        undoRedoBox.add(this.undoButton);
        undoRedoBox.add(Box.createHorizontalStrut(2));
        undoRedoBox.add(this.redoButton);
        undoRedoBox.add(Box.createGlue());
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)buttonBox, "Center");
        content.add((Component)undoRedoBox, "South");
        this.setSize(400, 150);
    }

    public void actionPerformed(ActionEvent ev) {
        JToggleButton tb = (JToggleButton)ev.getSource();
        this.edit = new UndoableToggleEdit(tb);
        this.undoButton.setText(this.edit.getUndoPresentationName());
        this.redoButton.setText(this.edit.getRedoPresentationName());
        this.undoButton.getParent().validate();
        this.undoButton.setEnabled(this.edit.canUndo());
        this.redoButton.setEnabled(this.edit.canRedo());
    }

    public static void main(String[] args) {
        UndoableToggleApp f = new UndoableToggleApp();
        f.addWindowListener(new BasicWindowMonitor());
        f.setVisible(true);
    }
}

