/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.undosystem.tutorial;

import exenne.components.undosystem.tutorial.BasicWindowMonitor;
import exenne.components.undosystem.tutorial.UndoableJToggleButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class UndoableToggleApp3
extends JFrame
implements UndoableEditListener {
    private UndoManager manager = new UndoManager();
    private JButton undoButton;
    private JButton redoButton;

    public UndoableToggleApp3() {
        UndoableJToggleButton tog1 = new UndoableJToggleButton("One");
        UndoableJToggleButton tog2 = new UndoableJToggleButton("Two");
        UndoableJToggleButton tog3 = new UndoableJToggleButton("Three");
        tog1.addUndoableEditListener(this);
        tog2.addUndoableEditListener(this);
        tog3.addUndoableEditListener(this);
        Box buttonBox = new Box(1);
        buttonBox.add(tog1);
        buttonBox.add(tog2);
        buttonBox.add(tog3);
        this.undoButton = new JButton("Undo");
        this.redoButton = new JButton("Redo");
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        this.undoButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    UndoableToggleApp3.this.manager.undo();
                }
                catch (CannotUndoException ex) {
                    ex.printStackTrace();
                }
                finally {
                    UndoableToggleApp3.this.updateButtons();
                }
            }
        });
        this.redoButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    UndoableToggleApp3.this.manager.redo();
                }
                catch (CannotRedoException ex) {
                    ex.printStackTrace();
                }
                finally {
                    UndoableToggleApp3.this.updateButtons();
                }
            }
        });
        Box undoRedoBox = new Box(0);
        undoRedoBox.add(Box.createGlue());
        undoRedoBox.add(this.undoButton);
        undoRedoBox.add(Box.createHorizontalStrut(2));
        undoRedoBox.add(this.redoButton);
        undoRedoBox.add(Box.createGlue());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)buttonBox, "Center");
        this.getContentPane().add((Component)undoRedoBox, "South");
        this.setSize(400, 150);
    }

    public void undoableEditHappened(UndoableEditEvent ev) {
        this.manager.addEdit(ev.getEdit());
        this.updateButtons();
    }

    protected void updateButtons() {
        this.undoButton.setText(this.manager.getUndoPresentationName());
        this.redoButton.setText(this.manager.getRedoPresentationName());
        this.undoButton.getParent().validate();
        this.undoButton.setEnabled(this.manager.canUndo());
        this.redoButton.setEnabled(this.manager.canRedo());
    }

    public static void main(String[] args) {
        UndoableToggleApp3 f = new UndoableToggleApp3();
        f.addWindowListener(new BasicWindowMonitor());
        f.setVisible(true);
    }
}

