/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.utils;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineArgumentParser {
    private Vector<String> vectorParams = new Vector();
    private Hashtable<String, String> hashtableOptions = new Hashtable();

    public CommandLineArgumentParser(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-") || args[i].startsWith("/")) {
                int loc = args[i].indexOf("=");
                String key = loc > 0 ? args[i].substring(1, loc) : args[i].substring(1);
                String value = loc > 0 ? args[i].substring(loc + 1) : "";
                this.hashtableOptions.put(key.toLowerCase(), value);
                continue;
            }
            this.vectorParams.addElement(args[i]);
        }
    }

    public boolean hasOption(String opt) {
        return this.hashtableOptions.containsKey(opt.toLowerCase());
    }

    public String getOption(String opt) {
        return this.hashtableOptions.get(opt.toLowerCase());
    }

    public Iterator<String> getParametersIterator() {
        return this.vectorParams.iterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Number of options = ").append(this.hashtableOptions.size());
        stringBuilder.append("\n");
        for (Map.Entry<String, String> hashEntry : this.hashtableOptions.entrySet()) {
            stringBuilder.append(hashEntry.getKey()).append("=").append(hashEntry.getValue());
            stringBuilder.append("\n");
        }
        stringBuilder.append("Number of paremeters = ").append(this.vectorParams.size());
        stringBuilder.append("\n");
        for (String param : this.vectorParams) {
            stringBuilder.append(param);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

