/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.utils;

import java.awt.Component;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class ComponentsUtils {
    public static BufferedImage loadImage(String imagePath) {
        BufferedImage result = null;
        URL imageURL = null;
        String imgLocation = null;
        if (imagePath != null) {
            imgLocation = imagePath;
            imageURL = ComponentsUtils.class.getResource(imgLocation);
            if (imageURL != null) {
                try {
                    result = ImageIO.read(imageURL);
                }
                catch (IOException ex) {
                    Logger.getLogger(ComponentsUtils.class.getName()).log(Level.WARNING, "IO error", ex);
                }
            } else {
                Logger.getLogger(ComponentsUtils.class.getName()).log(Level.WARNING, "File: {0} not found !", imagePath);
            }
        }
        return result;
    }

    public static void setFontBold(Component component) {
        Font oldFont = component.getFont();
        if (oldFont != null) {
            component.setFont(oldFont.deriveFont(1));
        }
    }

    public static void setFontPlain(Component component) {
        Font oldFont = component.getFont();
        if (oldFont != null) {
            component.setFont(oldFont.deriveFont(0));
        }
    }

    public static void increaseFontSize(JComponent component, int offset) {
        Font oldFont = component.getFont();
        if (oldFont != null) {
            component.setFont(oldFont.deriveFont(oldFont.getStyle(), oldFont.getSize() + offset));
        }
    }

    public static Action getActionForKeystroke(JComponent component, KeyStroke keyStroke) {
        Action whenFocused = ComponentsUtils.getActionForKeystroke(component, 0, keyStroke);
        Action whenAncestorOfFocused = ComponentsUtils.getActionForKeystroke(component, 1, keyStroke);
        Action whenInWindow = ComponentsUtils.getActionForKeystroke(component, 2, keyStroke);
        if (whenFocused != null) {
            return whenFocused;
        }
        if (whenAncestorOfFocused != null) {
            return whenAncestorOfFocused;
        }
        if (whenInWindow != null) {
            return whenInWindow;
        }
        return null;
    }

    public static Action getActionForKeystroke(JComponent component, int inputMapId, KeyStroke keyStroke) {
        InputMap inputMap = component.getInputMap(inputMapId);
        String key = (String)inputMap.get(keyStroke);
        if (key != null) {
            ActionMap localMap = component.getActionMap();
            return localMap.get(key);
        }
        return null;
    }
}

