/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.utils;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;

public class MouseEventForwarder
implements MouseListener,
MouseWheelListener,
MouseMotionListener {
    private Component destinationComponent;

    public MouseEventForwarder(Component destinationComponent) {
        this.destinationComponent = destinationComponent;
    }

    public void mouseClicked(MouseEvent e) {
        this.forwardEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.forwardEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.forwardEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
        this.forwardEvent(e);
    }

    public void mouseExited(MouseEvent e) {
        this.forwardEvent(e);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.forwardEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.forwardEvent(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.forwardEvent(e);
    }

    private void forwardEvent(MouseEvent e) {
        Point translatedPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.destinationComponent);
        MouseEvent translatedMouseEvent = new MouseEvent(this.destinationComponent, e.getID(), e.getWhen(), e.getModifiers(), translatedPoint.x, translatedPoint.y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        this.destinationComponent.dispatchEvent(translatedMouseEvent);
    }

    private void forwardEvent(MouseWheelEvent e) {
        Point translatedPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.destinationComponent);
        MouseWheelEvent translatedMouseEvent = new MouseWheelEvent(this.destinationComponent, e.getID(), e.getWhen(), e.getModifiers(), translatedPoint.x, translatedPoint.y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
        this.destinationComponent.dispatchEvent(translatedMouseEvent);
    }
}

