/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.coloredtable.cellrenderers;

import exenne.components.coloredtable.AbstractColoredTableModel;
import exenne.components.coloredtable.JColoredTable;
import exenne.components.utils.GraphicRenderingUtils;
import exenne.components.utils.NumberUtils;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public abstract class AbstractColoredCellRenderer
extends DefaultTableCellRenderer {
    private JColoredTable coloredTable = null;
    private AbstractColoredTableModel coloredTableModel = null;
    private boolean isSelected = false;
    private boolean hasSomeFocus = false;
    private boolean isCellEditable = false;
    private boolean hasToolTipText = false;
    private Color prefferedBackground = null;
    private Color prefferedForeground = null;
    private int colorOffset = 15;

    public JColoredTable getColoredTable() {
        return this.coloredTable;
    }

    public AbstractColoredTableModel getColoredTableModel() {
        return this.coloredTableModel;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean hasSomeFocus() {
        return this.hasSomeFocus;
    }

    public boolean isCellEditable() {
        return this.isCellEditable;
    }

    public boolean hasToolTipText() {
        return this.hasToolTipText;
    }

    public Color getPrefferedBackground() {
        return this.prefferedBackground;
    }

    public Color getPrefferedForeground() {
        return this.prefferedForeground;
    }

    public int getColorOffset() {
        return this.colorOffset;
    }

    protected void setIsSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    protected void setHasSomeFocus(boolean hasSomeFocus) {
        this.hasSomeFocus = hasSomeFocus;
    }

    protected void setIsCellEditable(boolean isCellEditable) {
        this.isCellEditable = isCellEditable;
    }

    protected void setHasToolTipText(boolean hasToolTipText) {
        this.hasToolTipText = hasToolTipText;
    }

    protected void setPrefferedBackground(Color prefferedBackground) {
        this.prefferedBackground = prefferedBackground;
    }

    protected void setPrefferedForeground(Color prefferedForeground) {
        this.prefferedForeground = prefferedForeground;
    }

    protected void setColorOffset(int colorOffset) {
        this.colorOffset = colorOffset;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color chosenForeground;
        Color chosenBackground;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.coloredTable = (JColoredTable)table;
        this.coloredTableModel = this.coloredTable.getModel();
        int modelrow = this.coloredTable.convertRowIndexToModel(row);
        int modelcolumn = this.coloredTable.convertColumnIndexToModel(column);
        this.isSelected = isSelected;
        this.hasSomeFocus = hasFocus;
        this.isCellEditable = this.coloredTableModel.isCellEditable(modelrow, modelcolumn);
        if (value instanceof String) {
            this.setText((String)value);
        } else if (value instanceof BigDecimal) {
            BigDecimal auxBigDecimal = (BigDecimal)value;
            this.setText(NumberUtils.formatBigDecimal(auxBigDecimal, this.coloredTableModel.getDecimalScale()));
        } else if (value instanceof Double) {
            Double auxDouble = (Double)value;
            this.setText(NumberUtils.formatDouble(auxDouble, this.coloredTableModel.getDecimalScale()));
        } else if (value instanceof Integer) {
            Integer auxInteger = (Integer)value;
            this.setText(NumberUtils.formatInteger(auxInteger));
        }
        this.setVerticalAlignment(1);
        if (value instanceof Number) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        String tooltipText = this.coloredTableModel.getTooltipText(modelrow, modelcolumn);
        this.setToolTipText(tooltipText);
        this.hasToolTipText = tooltipText != null;
        this.prefferedBackground = this.coloredTableModel.getBackground(modelrow);
        this.prefferedForeground = this.coloredTableModel.getForeground(modelrow);
        if (isSelected) {
            chosenBackground = table.getSelectionBackground();
            chosenForeground = table.getSelectionForeground();
        } else {
            chosenBackground = this.prefferedBackground;
            chosenForeground = this.prefferedForeground;
        }
        if (row % 2 == 0) {
            this.setBackground(GraphicRenderingUtils.lightenColor(chosenBackground, this.colorOffset));
        } else {
            this.setBackground(GraphicRenderingUtils.darkenColor(chosenBackground, this.colorOffset));
        }
        this.setForeground(chosenForeground);
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("isSelected = " + this.isSelected);
        stringBuffer.append('\n');
        stringBuffer.append("hasSomeFocus = " + this.hasSomeFocus);
        stringBuffer.append('\n');
        stringBuffer.append("isCellEditable = " + this.isCellEditable);
        stringBuffer.append('\n');
        stringBuffer.append("hasToolTipText = " + this.hasToolTipText);
        stringBuffer.append('\n');
        stringBuffer.append("text = " + this.getText());
        stringBuffer.append('\n');
        stringBuffer.append("background = " + this.getBackground());
        stringBuffer.append('\n');
        stringBuffer.append("foreground = " + this.getForeground());
        stringBuffer.append('\n');
        stringBuffer.append("prefferedBackground = " + this.prefferedBackground);
        stringBuffer.append('\n');
        stringBuffer.append("prefferedForeground = " + this.prefferedForeground);
        stringBuffer.append('\n');
        stringBuffer.append("==========================");
        return stringBuffer.toString();
    }
}

