/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.checktree.test;

import exenne.components.checktree.CheckTreeManager;
import exenne.components.checktree.test.JTestCheckTreeRenderer;
import exenne.components.tree.expansion.TreeNodesUtils;
import exenne.components.utils.RandomDataGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JTestCheckTree
extends JPanel {
    private CheckTreeManager checkTreeManager;
    private JTree tree;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private JTestCheckTreeRenderer myCheckTreeRenderer;

    public JTestCheckTree(DefaultMutableTreeNode rootNode) {
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("test panel"), "North");
        this.rootNode = rootNode;
        if (rootNode != null) {
            this.treeModel = new DefaultTreeModel(rootNode);
            this.tree = new JTree(this.treeModel);
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setShowsRootHandles(false);
            this.tree.setRootVisible(true);
            this.tree.setEditable(false);
            this.tree.setToggleClickCount(-1);
            this.myCheckTreeRenderer = new JTestCheckTreeRenderer();
            this.tree.setCellRenderer(this.myCheckTreeRenderer);
            this.checkTreeManager = new CheckTreeManager(this.tree);
            this.initialExpand();
            this.add(new JScrollPane(this.tree));
        }
    }

    private void initialExpand() {
        TreeNodesUtils.expandAll(this.tree, true);
    }

    public TreePath[] getCheckedPaths() {
        TreePath[] checkedPaths = this.checkTreeManager.getSelectionModel().getSelectionPaths();
        return checkedPaths;
    }

    private static DefaultMutableTreeNode generateRandomNode(int depth) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("node_" + RandomDataGenerator.getRandomString(3));
        if (depth > 0) {
            int childs = RandomDataGenerator.getRandomInt(3);
            for (int i = 0; i < childs; ++i) {
                DefaultMutableTreeNode child = JTestCheckTree.generateRandomNode(depth - 1);
                node.add(child);
            }
        }
        return node;
    }

    private static void createAndShowGUI() {
        JTestCheckTree.initLookAndFeel();
        JFrame frame = new JFrame("TableSelectionDemo");
        frame.setDefaultCloseOperation(3);
        JTestCheckTree testClass = new JTestCheckTree(JTestCheckTree.generateRandomNode(3));
        frame.add(testClass);
        frame.setSize(500, 500);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    public static void initLookAndFeel() {
        String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Locale.setDefault(new Locale("ro", "RO"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JTestCheckTree.createAndShowGUI();
            }
        });
    }
}

