/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.jdatepicker;

import exenne.components.jdatepicker.DateModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateModel<T>
implements DateModel<T> {
    private boolean selected = false;
    private Calendar calendarValue;
    private HashSet<ChangeListener> changeListeners = new HashSet();
    private HashSet<PropertyChangeListener> propertyChangeListeners = new HashSet();

    protected AbstractDateModel() {
        this.calendarValue = Calendar.getInstance();
    }

    @Override
    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    @Override
    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected synchronized void fireChangeEvent() {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    protected synchronized void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
    }

    @Override
    public int getDay() {
        return this.calendarValue.get(5);
    }

    @Override
    public int getMonth() {
        return this.calendarValue.get(2);
    }

    @Override
    public int getYear() {
        return this.calendarValue.get(1);
    }

    @Override
    public T getValue() {
        if (!this.selected) {
            return null;
        }
        T value = this.fromCalendar(this.calendarValue);
        return value;
    }

    @Override
    public void setDay(int day) {
        int oldDayValue = this.calendarValue.get(5);
        T oldValue = this.getValue();
        this.calendarValue.set(5, day);
        this.fireChangeEvent();
        this.firePropertyChange("day", oldDayValue, this.calendarValue.get(5));
        this.firePropertyChange("value", oldValue, this.getValue());
    }

    @Override
    public void addDay(int add) {
        int oldDayValue = this.calendarValue.get(5);
        T oldValue = this.getValue();
        this.calendarValue.add(5, add);
        this.fireChangeEvent();
        this.firePropertyChange("day", oldDayValue, this.calendarValue.get(5));
        this.firePropertyChange("value", oldValue, this.getValue());
    }

    @Override
    public void setMonth(int month) {
        int oldMonthValue = this.calendarValue.get(2);
        T oldValue = this.getValue();
        this.calendarValue.set(2, month);
        this.fireChangeEvent();
        this.firePropertyChange("month", oldMonthValue, this.calendarValue.get(2));
        this.firePropertyChange("value", oldValue, this.getValue());
    }

    @Override
    public void addMonth(int add) {
        int oldMonthValue = this.calendarValue.get(2);
        T oldValue = this.getValue();
        this.calendarValue.add(2, add);
        this.fireChangeEvent();
        this.firePropertyChange("month", oldMonthValue, this.calendarValue.get(2));
        this.firePropertyChange("value", oldValue, this.getValue());
    }

    @Override
    public void setYear(int year) {
        int oldYearValue = this.calendarValue.get(1);
        T oldValue = this.getValue();
        this.calendarValue.set(1, year);
        this.fireChangeEvent();
        this.firePropertyChange("year", oldYearValue, this.calendarValue.get(1));
        this.firePropertyChange("value", oldValue, this.getValue());
    }

    @Override
    public void addYear(int add) {
        int oldYearValue = this.calendarValue.get(1);
        T oldValue = this.getValue();
        this.calendarValue.add(1, add);
        this.fireChangeEvent();
        this.firePropertyChange("year", oldYearValue, this.calendarValue.get(1));
        this.firePropertyChange("value", oldValue, this.getValue());
    }

    @Override
    public void setValue(T value) {
        int oldYearValue = this.calendarValue.get(1);
        int oldMonthValue = this.calendarValue.get(2);
        int oldDayValue = this.calendarValue.get(5);
        T oldValue = this.getValue();
        boolean oldSelectedValue = this.isSelected();
        if (value != null) {
            this.calendarValue = this.toCalendar(value);
            this.setToMidnight();
            this.selected = true;
        } else {
            this.selected = false;
        }
        this.fireChangeEvent();
        this.firePropertyChange("year", oldYearValue, this.calendarValue.get(1));
        this.firePropertyChange("month", oldMonthValue, this.calendarValue.get(2));
        this.firePropertyChange("day", oldDayValue, this.calendarValue.get(5));
        this.firePropertyChange("value", oldValue, this.getValue());
        this.firePropertyChange("selected", oldSelectedValue, this.selected);
    }

    @Override
    public void setDate(int year, int month, int day) {
        int oldYearValue = this.calendarValue.get(1);
        int oldMonthValue = this.calendarValue.get(2);
        int oldDayValue = this.calendarValue.get(5);
        T oldValue = this.getValue();
        this.calendarValue.set(year, month, day);
        this.fireChangeEvent();
        this.firePropertyChange("year", oldYearValue, this.calendarValue.get(1));
        this.firePropertyChange("month", oldMonthValue, this.calendarValue.get(2));
        this.firePropertyChange("day", oldDayValue, this.calendarValue.get(5));
        this.firePropertyChange("value", oldValue, this.getValue());
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        T oldValue = this.getValue();
        boolean oldSelectedValue = this.isSelected();
        this.selected = selected;
        this.fireChangeEvent();
        this.firePropertyChange("value", oldValue, this.getValue());
        this.firePropertyChange("selected", oldSelectedValue, this.selected);
    }

    private void setToMidnight() {
        this.calendarValue.set(10, 0);
        this.calendarValue.set(12, 0);
        this.calendarValue.set(13, 0);
        this.calendarValue.set(14, 0);
    }

    protected abstract Calendar toCalendar(T var1);

    protected abstract T fromCalendar(Calendar var1);
}

