/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.tree.expansion;

import exenne.components.tree.expansion.NodeExpansionValidator;
import exenne.components.treetable.Treetable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodesUtils {
    public static DefaultMutableTreeNode findObjectInTree(DefaultMutableTreeNode node, Object object) {
        Enumeration<TreeNode> enumeration = node.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode nodeItem = (DefaultMutableTreeNode)enumeration.nextElement();
            Object userObject = nodeItem.getUserObject();
            if (object == null || !object.equals(userObject)) continue;
            return nodeItem;
        }
        return null;
    }

    public static Vector<DefaultMutableTreeNode> findObjectsInTree(DefaultMutableTreeNode node, Vector<Object> objects) {
        Vector<DefaultMutableTreeNode> foundNodes = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = node.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode nodeItem = (DefaultMutableTreeNode)enumeration.nextElement();
            Object userObject = nodeItem.getUserObject();
            if (!objects.contains(userObject)) continue;
            foundNodes.add(nodeItem);
        }
        return foundNodes;
    }

    public static void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        TreeNodesUtils.expandAll(tree, new TreePath(root), expand);
    }

    public static void expandAll(Treetable treetable, DefaultMutableTreeNode root, boolean expand) {
        TreeNodesUtils.expandAll(treetable, new TreePath(root), expand);
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                if (n.isLeaf()) continue;
                TreePath path = parent.pathByAddingChild(n);
                TreeNodesUtils.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private static void expandAll(Treetable treetable, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                if (n.isLeaf()) continue;
                TreePath path = parent.pathByAddingChild(n);
                TreeNodesUtils.expandAll(treetable, path, expand);
            }
        }
        if (expand) {
            treetable.expandPath(parent);
        } else {
            boolean isRoot = ((DefaultMutableTreeNode)parent.getLastPathComponent()).isRoot();
            if (!isRoot) {
                treetable.collapsePath(parent);
            }
        }
    }

    public static void expandAllButClasses(Treetable treetable, TreePath parent, boolean expand, Class ... forbidenClasses) {
        List<Class> forbidenClassesList = Arrays.asList(forbidenClasses);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                Object object = n.getUserObject();
                Class<?> objectClass = object.getClass();
                if (n.isLeaf() || forbidenClassesList.contains(objectClass)) continue;
                System.out.println(objectClass);
                TreePath path = parent.pathByAddingChild(n);
                TreeNodesUtils.expandAllButClasses(treetable, path, expand, forbidenClasses);
            }
        }
        if (expand) {
            treetable.expandPath(parent);
        } else {
            treetable.collapsePath(parent);
        }
    }

    public static void expandAllWithValidation(Treetable treetable, TreePath parent, boolean expand, NodeExpansionValidator validator) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                Object object = n.getUserObject();
                if (n.isLeaf() || !validator.validate(object)) continue;
                TreePath path = parent.pathByAddingChild(n);
                TreeNodesUtils.expandAllWithValidation(treetable, path, expand, validator);
            }
        }
        if (expand) {
            treetable.expandPath(parent);
        } else {
            treetable.collapsePath(parent);
        }
    }
}

