/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.ElementWrapper;
import net.sf.jasperreports.engine.export.JRGridLayout;

public abstract class JRExporterGridCell {
    public static byte TYPE_EMPTY_CELL = 1;
    public static byte TYPE_OCCUPIED_CELL = (byte)2;
    public static byte TYPE_ELEMENT_CELL = (byte)3;
    private ElementWrapper wrapper = null;
    private Color backcolor;
    private Color forecolor;
    private JRLineBox box;
    private int width = 0;
    private int height = 0;
    private int colSpan = 0;
    private int rowSpan = 0;
    private JRGridLayout layout = null;

    public JRExporterGridCell(ElementWrapper wrapper, int width, int height, int colSpan, int rowSpan) {
        this.wrapper = wrapper;
        this.width = width;
        this.height = height;
        this.colSpan = colSpan;
        this.rowSpan = rowSpan;
    }

    public ElementWrapper getWrapper() {
        return this.wrapper;
    }

    public JRPrintElement getElement() {
        return this.wrapper == null ? null : this.wrapper.getElement();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public JRGridLayout getLayout() {
        return this.layout;
    }

    public void setLayout(JRGridLayout layout) {
        this.layout = layout;
    }

    public Color getBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color backcolor) {
        this.backcolor = backcolor;
    }

    public JRLineBox getBox() {
        return this.box;
    }

    public void setBox(JRLineBox box) {
        this.box = box;
    }

    public Color getForecolor() {
        return this.forecolor;
    }

    public void setForecolor(Color forecolor) {
        this.forecolor = forecolor;
    }

    public Color getCellBackcolor() {
        JRPrintElement element = this.getElement();
        Color color = element != null && element.getMode() == 1 ? element.getBackcolor() : this.backcolor;
        return color;
    }

    public boolean isEmpty() {
        return this.wrapper == null && this.backcolor == null && this.box == null;
    }

    public abstract byte getType();
}

